/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.unomi.api.Consent;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyConsentAction
implements ActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ModifyConsentAction.class.getName());
    public static final String CONSENT_PROPERTY_NAME = "consent";

    public int execute(Action action, Event event) {
        Profile profile = event.getProfile();
        boolean isProfileUpdated = false;
        ISO8601DateFormat dateFormat = new ISO8601DateFormat();
        Map consentMap = (Map)event.getProperties().get(CONSENT_PROPERTY_NAME);
        if (consentMap != null) {
            if (consentMap.containsKey("typeIdentifier") && consentMap.containsKey("status")) {
                Consent consent = null;
                try {
                    consent = new Consent(consentMap, (DateFormat)dateFormat);
                    isProfileUpdated = profile.setConsent(consent);
                }
                catch (ParseException e) {
                    LOGGER.error("Error parsing consent dates (statusDate or revokeDate). See debug log level to have more information");
                    LOGGER.debug("Error parsing consent dates (statusDate or revokeDate).", (Throwable)e);
                }
            } else {
                LOGGER.warn("Event properties for modifyConsent is missing typeIdentifier and grant properties. We will ignore this event.");
            }
        }
        return isProfileUpdated ? 4 : 0;
    }
}

