/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeProfilesOnPropertyAction
implements ActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MergeProfilesOnPropertyAction.class.getName());
    private ProfileService profileService;
    private PersistenceService persistenceService;
    private EventService eventService;
    private DefinitionsService definitionsService;
    private PrivacyService privacyService;
    private SchedulerService schedulerService;
    private int maxProfilesInOneMerge = 50;

    public int execute(Action action, Event event) {
        Profile eventProfile = event.getProfile();
        String mergePropName = (String)action.getParameterValues().get("mergeProfilePropertyName");
        String mergePropValue = (String)action.getParameterValues().get("mergeProfilePropertyValue");
        String clientIdFromEvent = (String)event.getAttributes().get("client_id");
        String clientId = clientIdFromEvent != null ? clientIdFromEvent : "defaultClientId";
        boolean forceEventProfileAsMaster = action.getParameterValues().containsKey("forceEventProfileAsMaster") ? (Boolean)action.getParameterValues().get("forceEventProfileAsMaster") : false;
        String currentProfileMergeValue = (String)eventProfile.getSystemProperties().get(mergePropName);
        if (eventProfile instanceof Persona || eventProfile.isAnonymousProfile() || StringUtils.isEmpty((CharSequence)mergePropName) || StringUtils.isEmpty((CharSequence)mergePropValue)) {
            return 0;
        }
        List<Profile> profilesToBeMerge = this.getProfilesToBeMerge(mergePropName, mergePropValue);
        if (StringUtils.isNotEmpty((CharSequence)currentProfileMergeValue) && !currentProfileMergeValue.equals(mergePropValue)) {
            this.reassignCurrentBrowsingData(event, profilesToBeMerge, forceEventProfileAsMaster, mergePropName, mergePropValue);
            return 6;
        }
        boolean profileUpdated = false;
        if (StringUtils.isEmpty((CharSequence)currentProfileMergeValue)) {
            profileUpdated = true;
            eventProfile.getSystemProperties().put(mergePropName, mergePropValue);
        }
        if (profilesToBeMerge.isEmpty()) {
            return profileUpdated ? 4 : 0;
        }
        if (profilesToBeMerge.stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getItemId(), (CharSequence)eventProfile.getItemId()))) {
            profilesToBeMerge.add(eventProfile);
        }
        String eventProfileId = eventProfile.getItemId();
        Profile masterProfile = this.profileService.mergeProfiles(forceEventProfileAsMaster ? eventProfile : profilesToBeMerge.get(0), profilesToBeMerge);
        String masterProfileId = masterProfile.getItemId();
        if (!forceEventProfileAsMaster && masterProfileId.equals(eventProfileId)) {
            return profileUpdated ? 4 : 0;
        }
        if (this.privacyService.isRequireAnonymousBrowsing(eventProfile).booleanValue()) {
            this.privacyService.setRequireAnonymousBrowsing(masterProfileId, true, event.getScope());
        }
        boolean anonymousBrowsing = this.privacyService.isRequireAnonymousBrowsing(masterProfileId);
        if (event.getSession() != null) {
            event.getSession().setProfile(anonymousBrowsing ? this.privacyService.getAnonymousProfile(masterProfile) : masterProfile);
        }
        event.setProfileId(anonymousBrowsing ? null : masterProfileId);
        event.setProfile(masterProfile);
        event.getActionPostExecutors().add(() -> {
            try {
                List<String> mergedProfileIds = profilesToBeMerge.stream().map(Item::getItemId).filter(mergedProfileId -> !StringUtils.equals((CharSequence)mergedProfileId, (CharSequence)masterProfileId)).collect(Collectors.toList());
                this.reassignPersistedBrowsingDatasAsync(anonymousBrowsing, mergedProfileIds, masterProfileId);
                if (event.isPersistent()) {
                    this.persistenceService.save((Item)event);
                }
                for (String mergedProfileId2 : mergedProfileIds) {
                    this.profileService.addAliasToProfile(masterProfileId, mergedProfileId2, clientId);
                    if (this.persistenceService.load(mergedProfileId2, Profile.class) == null) continue;
                    this.profileService.delete(mergedProfileId2, false);
                }
            }
            catch (Exception e) {
                LOGGER.error("unable to execute callback action, profile and session will not be saved", (Throwable)e);
                return false;
            }
            return true;
        });
        return 6;
    }

    private List<Profile> getProfilesToBeMerge(String mergeProfilePropertyName, String mergeProfilePropertyValue) {
        Condition propertyCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        propertyCondition.setParameter("comparisonOperator", (Object)"equals");
        propertyCondition.setParameter("propertyName", (Object)("systemProperties." + mergeProfilePropertyName));
        propertyCondition.setParameter("propertyValue", (Object)mergeProfilePropertyValue);
        return this.persistenceService.query(propertyCondition, "properties.firstVisit", Profile.class, 0, this.maxProfilesInOneMerge).getList();
    }

    private void reassignPersistedBrowsingDatasAsync(final boolean anonymousBrowsing, final List<String> mergedProfileIds, final String masterProfileId) {
        this.schedulerService.getSharedScheduleExecutorService().schedule(new TimerTask(){

            @Override
            public void run() {
                if (!anonymousBrowsing) {
                    Condition profileIdsCondition = new Condition(MergeProfilesOnPropertyAction.this.definitionsService.getConditionType("eventPropertyCondition"));
                    profileIdsCondition.setParameter("propertyName", (Object)"profileId");
                    profileIdsCondition.setParameter("comparisonOperator", (Object)"in");
                    profileIdsCondition.setParameter("propertyValues", (Object)mergedProfileIds);
                    String[] scripts = new String[]{"updateProfileId"};
                    Map[] scriptParams = new Map[]{Collections.singletonMap("profileId", masterProfileId)};
                    Condition[] conditions = new Condition[]{profileIdsCondition};
                    MergeProfilesOnPropertyAction.this.persistenceService.updateWithQueryAndStoredScript(new Class[]{Session.class, Event.class}, scripts, scriptParams, conditions, false);
                } else {
                    for (String mergedProfileId : mergedProfileIds) {
                        MergeProfilesOnPropertyAction.this.privacyService.anonymizeBrowsingData(mergedProfileId);
                    }
                }
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private void reassignCurrentBrowsingData(Event event, List<Profile> existingMergedProfiles, boolean forceEventProfileAsMaster, String mergePropName, String mergePropValue) {
        Profile eventProfile = event.getProfile();
        if (existingMergedProfiles.size() > 0) {
            eventProfile = existingMergedProfiles.get(0);
        } else {
            if (!forceEventProfileAsMaster) {
                eventProfile = new Profile(UUID.randomUUID().toString());
                eventProfile.setProperty("firstVisit", (Object)event.getTimeStamp());
            }
            eventProfile.getSystemProperties().put(mergePropName, mergePropValue);
        }
        LOGGER.info("Different users, switch to {}", (Object)eventProfile.getItemId());
        event.setProfileId(eventProfile.getItemId());
        event.setProfile(eventProfile);
        if (event.getSession() != null) {
            Session eventSession = event.getSession();
            eventSession.setProfile(eventProfile);
            this.eventService.send(new Event("sessionReassigned", eventSession, eventProfile, event.getScope(), (Item)event, (Item)eventSession, null, event.getTimeStamp(), false));
        }
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setPrivacyService(PrivacyService privacyService) {
        this.privacyService = privacyService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setMaxProfilesInOneMerge(String maxProfilesInOneMerge) {
        this.maxProfilesInOneMerge = Integer.parseInt(maxProfilesInOneMerge);
    }
}

