/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.fit.pipeline.JCasIterable;
import org.apache.uima.fit.util.LifeCycleUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.CasCreationUtils;

public final class SimplePipeline {
    private SimplePipeline() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPipeline(CollectionReader reader, AnalysisEngineDescription ... descs) throws IOException, ResourceInitializationException, AnalysisEngineProcessException, CollectionException {
        AnalysisEngine aae = null;
        try {
            AnalysisEngineDescription aaeDesc = AnalysisEngineFactory.createEngineDescription(descs);
            aae = AnalysisEngineFactory.createEngine(aaeDesc, new Object[0]);
            CAS cas = CasCreationUtils.createCas(Arrays.asList(reader.getMetaData(), aae.getMetaData()), null, (ResourceManager)reader.getResourceManager());
            reader.typeSystemInit(cas.getTypeSystem());
            while (reader.hasNext()) {
                reader.getNext(cas);
                aae.process(cas);
                cas.reset();
            }
            aae.collectionProcessComplete();
        }
        catch (Throwable throwable) {
            LifeCycleUtil.destroy(new Resource[]{aae});
            throw throwable;
        }
        LifeCycleUtil.destroy(new Resource[]{aae});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPipeline(CollectionReaderDescription readerDesc, AnalysisEngineDescription ... descs) throws IOException, ResourceInitializationException, AnalysisEngineProcessException, CollectionException {
        CollectionReader reader = null;
        AnalysisEngine aae = null;
        ResourceManager resMgr = null;
        try {
            resMgr = ResourceManagerFactory.newResourceManager();
            reader = UIMAFramework.produceCollectionReader((ResourceSpecifier)readerDesc, (ResourceManager)resMgr, null);
            AnalysisEngineDescription aaeDesc = AnalysisEngineFactory.createEngineDescription(descs);
            aae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aaeDesc, (ResourceManager)resMgr, null);
            CAS cas = CasCreationUtils.createCas(Arrays.asList(reader.getMetaData(), aae.getMetaData()), null, (ResourceManager)resMgr);
            reader.typeSystemInit(cas.getTypeSystem());
            while (reader.hasNext()) {
                reader.getNext(cas);
                aae.process(cas);
                cas.reset();
            }
            aae.collectionProcessComplete();
        }
        catch (Throwable throwable) {
            LifeCycleUtil.destroy(new Resource[]{reader});
            LifeCycleUtil.destroy(new Resource[]{aae});
            LifeCycleUtil.destroy(resMgr);
            throw throwable;
        }
        LifeCycleUtil.destroy(new Resource[]{reader});
        LifeCycleUtil.destroy(new Resource[]{aae});
        LifeCycleUtil.destroy(resMgr);
    }

    public static void runPipeline(CollectionReader reader, AnalysisEngine ... engines) throws IOException, AnalysisEngineProcessException, ResourceInitializationException, CollectionException {
        SimplePipeline.runPipeline(reader.getResourceManager(), reader, engines);
    }

    public static void runPipeline(ResourceManager aResMgr, CollectionReader reader, AnalysisEngine ... engines) throws IOException, ResourceInitializationException, AnalysisEngineProcessException, CollectionException {
        ArrayList<ResourceMetaData> metaData = new ArrayList<ResourceMetaData>();
        metaData.add(reader.getMetaData());
        for (AnalysisEngine engine : engines) {
            metaData.add(engine.getMetaData());
        }
        CAS cas = CasCreationUtils.createCas(metaData, null, (ResourceManager)aResMgr);
        reader.typeSystemInit(cas.getTypeSystem());
        while (reader.hasNext()) {
            reader.getNext(cas);
            SimplePipeline.runPipeline(cas, engines);
            cas.reset();
        }
        LifeCycleUtil.collectionProcessComplete(engines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPipeline(CAS aCas, AnalysisEngineDescription ... aDescs) throws ResourceInitializationException, AnalysisEngineProcessException {
        AnalysisEngine aae = null;
        try {
            AnalysisEngineDescription aaeDesc = AnalysisEngineFactory.createEngineDescription(aDescs);
            aae = AnalysisEngineFactory.createEngine(aaeDesc, new Object[0]);
            aae.process(aCas);
            aae.collectionProcessComplete();
        }
        catch (Throwable throwable) {
            LifeCycleUtil.destroy(new Resource[]{aae});
            throw throwable;
        }
        LifeCycleUtil.destroy(new Resource[]{aae});
    }

    public static void runPipeline(JCas jCas, AnalysisEngineDescription ... descs) throws AnalysisEngineProcessException, ResourceInitializationException {
        SimplePipeline.runPipeline(jCas.getCas(), descs);
    }

    public static void runPipeline(JCas jCas, AnalysisEngine ... engines) throws AnalysisEngineProcessException {
        for (AnalysisEngine engine : engines) {
            engine.process(jCas);
        }
    }

    public static void runPipeline(CAS cas, AnalysisEngine ... engines) throws AnalysisEngineProcessException {
        for (AnalysisEngine engine : engines) {
            engine.process(cas);
        }
    }

    public static JCasIterable iteratePipeline(CollectionReaderDescription aReader, AnalysisEngineDescription ... aEngines) {
        return new JCasIterable(aReader, aEngines);
    }
}

