/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_string;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.tools.cvd.ArrayNode;
import org.apache.uima.tools.cvd.FSNode;
import org.apache.uima.tools.cvd.FSTreeNode;

public class FSTreeModel
implements TreeModel {
    private FSTreeNode root;
    private CASImpl cas;
    private List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    private List<FSNode> fss;
    private static final String defaultRootString = "<html><b><font color=#808080>FS List - no selection</b></html>";
    private String rootString = "<html><b><font color=#808080>FS List - no selection</b></html>";

    public FSTreeModel() {
        this.root = new FSNode(this, 5, null, 0L, null);
        this.root.setChildren(new ArrayList<FSTreeNode>());
    }

    public void update(String indexName, FSIndex index, CAS cas1) {
        this.cas = (CASImpl)cas1;
        int size = index.size();
        this.rootString = "<html><font color=green>" + indexName + "</font> - <font color=blue>" + index.getType().getName() + "</font> [" + size + "]</html>";
        this.root = new FSNode(this, 5, null, 0L, null);
        this.fss = new ArrayList<FSNode>();
        FSIterator it = index.iterator();
        int count = 0;
        it.moveToFirst();
        while (it.isValid()) {
            TOP fs = (TOP)it.get();
            this.fss.add(new FSNode(this, this.getNodeType(fs.getType()), (Object)fs, (long)fs._id(), count));
            ++count;
            it.moveToNext();
        }
        List<FSTreeNode> kids = FSTreeModel.createArrayChildren(0, size, this.fss, this);
        this.root.setChildren(kids);
        Object[] path = new Object[]{this.root};
        TreeModelEvent event = new TreeModelEvent((Object)this.root, path);
        for (int i = 0; i < this.treeModelListeners.size(); ++i) {
            this.treeModelListeners.get(i).treeStructureChanged(event);
        }
    }

    public void reset() {
        this.root.removeAllChildren();
        this.rootString = defaultRootString;
        Object[] path = new Object[]{this.root};
        TreeModelEvent event = new TreeModelEvent((Object)this.root, path);
        for (int i = 0; i < this.treeModelListeners.size(); ++i) {
            this.treeModelListeners.get(i).treeStructureChanged(event);
        }
    }

    public List<FSNode> getFSs() {
        return this.fss;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        FSTreeNode node = (FSTreeNode)parent;
        node.initChildren();
        return node.getChildren().get(index);
    }

    int getNodeType(Type type) {
        if (type instanceof TypeImpl_string) {
            return 2;
        }
        switch (((TypeImpl)type).getCode()) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 6: {
                return 3;
            }
            case 29: {
                return 6;
            }
            case 28: {
                return 7;
            }
            case 30: {
                return 8;
            }
            case 31: {
                return 9;
            }
            case 32: {
                return 10;
            }
        }
        return 4;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((FSTreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        FSTreeNode node = (FSTreeNode)parent;
        node.initChildren();
        return node.getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener arg0) {
        this.treeModelListeners.add(arg0);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
        this.treeModelListeners.remove(arg0);
    }

    CASImpl getCas() {
        return this.cas;
    }

    String getRootString() {
        return this.rootString;
    }

    static List<FSTreeNode> createArrayChildren(int start, int end, List<FSNode> array, FSTreeModel model) {
        ArrayList<FSTreeNode> kids = new ArrayList<FSTreeNode>();
        int size = end - start;
        if (size <= 100) {
            kids.ensureCapacity(size);
            for (int i = start; i < end; ++i) {
                kids.add(array.get(i));
            }
        } else {
            ArrayNode node;
            int deg = ArrayNode.degree(size);
            int divisor = (int)Math.pow(10.0, deg);
            int buckets = size / divisor;
            int rem = size % divisor;
            for (int i = 0; i < buckets; ++i) {
                int start_i = start + i * divisor;
                int end_i = start_i + divisor;
                node = new ArrayNode(start_i, end_i - 1);
                List<FSTreeNode> grandkids = FSTreeModel.createArrayChildren(start_i, end_i, array, model);
                node.setChildren(grandkids);
                kids.add(node);
            }
            if (rem > 0) {
                int start_rem = start + buckets * divisor;
                if (rem <= 100) {
                    for (int i = start_rem; i < end; ++i) {
                        kids.add(array.get(i));
                    }
                } else {
                    node = new ArrayNode(start_rem, end - 1);
                    node.setChildren(FSTreeModel.createArrayChildren(start_rem, end, array, model));
                    kids.add(node);
                }
            }
        }
        return kids;
    }

    public TreePath pathToNode(int fsNum) {
        ArrayList<FSTreeNode> p = new ArrayList<FSTreeNode>();
        p.add(this.root);
        this.getPathToNode(fsNum, this.root.getChildren(), p);
        TreePath path = new TreePath(p.toArray());
        return path;
    }

    private void getPathToNode(int n, List<FSTreeNode> dtrs, List<FSTreeNode> path) {
        for (int i = 0; i < dtrs.size(); ++i) {
            FSTreeNode node = dtrs.get(i);
            if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                if (arrayNode.getEnd() < n) continue;
                path.add(node);
                this.getPathToNode(n, node.getChildren(), path);
                return;
            }
            FSNode fsNode = (FSNode)node;
            if (fsNode.getArrayPos() != n) continue;
            path.add(node);
            return;
        }
    }
}

