/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler;

import com.strobel.assembler.ir.ConstantPool;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.core.StringComparison;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.io.PathHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputTypeLoader
implements ITypeLoader {
    private static final Logger LOG = Logger.getLogger(InputTypeLoader.class.getSimpleName());
    private final ITypeLoader _defaultTypeLoader;
    private final Map<String, LinkedHashSet<File>> _packageLocations;
    private final Map<String, File> _knownFiles;

    public InputTypeLoader() {
        this(new ClasspathTypeLoader());
    }

    public InputTypeLoader(ITypeLoader defaultTypeLoader) {
        this._defaultTypeLoader = (ITypeLoader)VerifyArgument.notNull((Object)defaultTypeLoader, (String)"defaultTypeLoader");
        this._packageLocations = new LinkedHashMap<String, LinkedHashSet<File>>();
        this._knownFiles = new LinkedHashMap<String, File>();
    }

    @Override
    public boolean tryLoadType(String typeNameOrPath, Buffer buffer) {
        String internalName;
        boolean hasExtension;
        VerifyArgument.notNull((Object)typeNameOrPath, (String)"typeNameOrPath");
        VerifyArgument.notNull((Object)buffer, (String)"buffer");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Attempting to load type: " + typeNameOrPath + "...");
        }
        if ((hasExtension = StringUtilities.endsWithIgnoreCase((CharSequence)typeNameOrPath, (String)".class")) && this.tryLoadFile(null, typeNameOrPath, buffer, true)) {
            return true;
        }
        if (PathHelper.isPathRooted((String)typeNameOrPath)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Failed to load type: " + typeNameOrPath + ".");
            }
            return false;
        }
        String string = internalName = hasExtension ? typeNameOrPath.substring(0, typeNameOrPath.length() - 6) : typeNameOrPath.replace('.', '/');
        if (this.tryLoadTypeFromName(internalName, buffer)) {
            return true;
        }
        if (hasExtension) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Failed to load type: " + typeNameOrPath + ".");
            }
            return false;
        }
        int lastDelimiter = internalName.lastIndexOf(47);
        while (lastDelimiter != -1) {
            if (this.tryLoadTypeFromName(internalName = internalName.substring(0, lastDelimiter) + "$" + internalName.substring(lastDelimiter + 1), buffer)) {
                return true;
            }
            lastDelimiter = internalName.lastIndexOf(47);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Failed to load type: " + typeNameOrPath + ".");
        }
        return false;
    }

    private boolean tryLoadTypeFromName(String internalName, Buffer buffer) {
        if (this.tryLoadFromKnownLocation(internalName, buffer)) {
            return true;
        }
        if (this._defaultTypeLoader.tryLoadType(internalName, buffer)) {
            return true;
        }
        String filePath = internalName.replace('/', File.separatorChar) + ".class";
        if (this.tryLoadFile(internalName, filePath, buffer, false)) {
            return true;
        }
        int lastSeparatorIndex = filePath.lastIndexOf(File.separatorChar);
        return lastSeparatorIndex >= 0 && this.tryLoadFile(internalName, filePath.substring(lastSeparatorIndex + 1), buffer, true);
    }

    private boolean tryLoadFromKnownLocation(String internalName, Buffer buffer) {
        String tail;
        String head;
        File knownFile = this._knownFiles.get(internalName);
        if (knownFile != null && this.tryLoadFile(knownFile, buffer)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Type loaded from " + knownFile.getAbsolutePath() + ".");
            }
            return true;
        }
        int packageEnd = internalName.lastIndexOf(47);
        if (packageEnd < 0 || packageEnd >= internalName.length()) {
            head = "";
            tail = internalName;
        } else {
            head = internalName.substring(0, packageEnd);
            tail = internalName.substring(packageEnd + 1);
        }
        while (true) {
            int split;
            LinkedHashSet<File> directories;
            if ((directories = this._packageLocations.get(head)) != null) {
                for (File directory : directories) {
                    if (!this.tryLoadFile(internalName, new File(directory, tail + ".class").getAbsolutePath(), buffer, true)) continue;
                    return true;
                }
            }
            if ((split = head.lastIndexOf(47)) <= 0) break;
            tail = head.substring(split + 1) + '/' + tail;
            head = head.substring(0, split);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryLoadFile(File file, Buffer buffer) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Probing for file: " + file.getAbsolutePath() + "...");
        }
        if (!file.exists()) return false;
        if (file.isDirectory()) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(file);){
            int bytesRead;
            int remainingBytes;
            buffer.position(0);
            buffer.reset(remainingBytes);
            for (remainingBytes = in.available(); remainingBytes > 0 && (bytesRead = in.read(buffer.array(), buffer.position(), remainingBytes)) >= 0; remainingBytes -= bytesRead) {
                buffer.advance(bytesRead);
            }
            buffer.position(0);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean tryLoadFile(String internalName, String typeNameOrPath, Buffer buffer, boolean trustName) {
        boolean result;
        String name;
        File file = new File(typeNameOrPath);
        if (!this.tryLoadFile(file, buffer)) {
            return false;
        }
        String actualName = InputTypeLoader.getInternalNameFromClassFile(buffer);
        String string = trustName ? (internalName != null ? internalName : actualName) : (name = actualName);
        if (name == null) {
            return false;
        }
        boolean nameMatches = StringUtilities.equals((String)actualName, (String)internalName);
        boolean pathMatchesName = typeNameOrPath.endsWith(name.replace('/', File.separatorChar) + ".class");
        boolean bl = result = internalName == null || pathMatchesName || nameMatches;
        if (result) {
            int packageEnd = name.lastIndexOf(47);
            String packageName = packageEnd < 0 || packageEnd >= name.length() ? "" : name.substring(0, packageEnd);
            this.registerKnownPath(packageName, file.getParentFile(), pathMatchesName);
            this._knownFiles.put(actualName, file);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Type loaded from " + file.getAbsolutePath() + ".");
            }
        } else {
            buffer.reset(0);
        }
        return result;
    }

    private void registerKnownPath(String packageName, File directory, boolean recursive) {
        if (directory == null || !directory.exists()) {
            return;
        }
        LinkedHashSet<File> directories = this._packageLocations.get(packageName);
        if (directories == null) {
            directories = new LinkedHashSet();
            this._packageLocations.put(packageName, directories);
        }
        if (!directories.add(directory) || !recursive) {
            return;
        }
        try {
            int delimiterIndex;
            String directoryPath = StringUtilities.removeRight((String)directory.getCanonicalPath(), (char[])new char[]{PathHelper.DirectorySeparator, PathHelper.AlternateDirectorySeparator}).replace('\\', '/');
            String currentPackage = packageName;
            File currentDirectory = new File(directoryPath);
            while ((delimiterIndex = currentPackage.lastIndexOf(47)) >= 0 && currentDirectory.exists() && delimiterIndex < currentPackage.length() - 1) {
                String segmentName = currentPackage.substring(delimiterIndex + 1);
                if (StringUtilities.equals((String)currentDirectory.getName(), (String)segmentName, (StringComparison)StringComparison.OrdinalIgnoreCase)) {
                    currentPackage = currentPackage.substring(0, delimiterIndex);
                    currentDirectory = currentDirectory.getParentFile();
                    directories = this._packageLocations.get(currentPackage);
                    if (directories == null) {
                        directories = new LinkedHashSet();
                        this._packageLocations.put(currentPackage, directories);
                    }
                    if (directories.add(currentDirectory)) continue;
                }
                break;
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    private static String getInternalNameFromClassFile(Buffer b) {
        long magic = (long)b.readInt() & 0xFFFFFFFFL;
        if (magic != 3405691582L) {
            return null;
        }
        b.readUnsignedShort();
        b.readUnsignedShort();
        ConstantPool constantPool = ConstantPool.read(b);
        b.readUnsignedShort();
        ConstantPool.TypeInfoEntry thisClass = (ConstantPool.TypeInfoEntry)constantPool.getEntry(b.readUnsignedShort());
        b.position(0);
        return thisClass.getName();
    }
}

