/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.FileLanguageResourceSpecifier;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.ParameterizedDataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;

public class FileLanguageResource_impl
extends Resource_ImplBase
implements ParameterizedDataResource {
    private String mFileUrlPrefix;
    private String mFileUrlSuffix;
    private Map<String, Object> mResourceInitParams;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof FileLanguageResourceSpecifier)) {
            return false;
        }
        FileLanguageResourceSpecifier spec = (FileLanguageResourceSpecifier)aSpecifier;
        this.mFileUrlPrefix = spec.getFileUrlPrefix();
        this.mFileUrlSuffix = spec.getFileUrlSuffix();
        this.mResourceInitParams = aAdditionalParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aAdditionalParams);
        super.initialize(aSpecifier, aAdditionalParams);
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public DataResource getDataResource(String[] aParams) throws ResourceInitializationException {
        if (aParams.length != 1) {
            throw new ResourceInitializationException("incorrect_number_of_parameters", new Object[]{"1"});
        }
        String lang = aParams[0];
        DataResource resource = null;
        ResourceInitializationException firstException = null;
        while (resource == null && lang != null) {
            int lastHyphen;
            int truncateAt;
            block6: {
                String urlString = this.mFileUrlPrefix + lang + this.mFileUrlSuffix;
                FileResourceSpecifier fileSpec = UIMAFramework.getResourceSpecifierFactory().createFileResourceSpecifier();
                fileSpec.setFileUrl(urlString);
                try {
                    resource = (DataResource)UIMAFramework.produceResource(DataResource.class, fileSpec, this.mResourceInitParams);
                }
                catch (ResourceInitializationException e) {
                    if (firstException != null) break block6;
                    firstException = e;
                }
            }
            if (resource != null) continue;
            int lastUnderscore = lang.lastIndexOf(95);
            int n = truncateAt = lastUnderscore > (lastHyphen = lang.lastIndexOf(45)) ? lastUnderscore : lastHyphen;
            if (truncateAt == -1) {
                lang = null;
                continue;
            }
            lang = lang.substring(0, truncateAt);
        }
        if (resource != null) {
            return resource;
        }
        throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{"[" + aParams[0] + "]"}, firstException);
    }
}

