/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.plugin;

import java.io.File;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.plugin.AbstractDataSourcePlugin;

public class HsqldbDataSourcePlugin
extends AbstractDataSourcePlugin {
    private static final String HSQL_FILE_URL = "jdbc:hsqldb:file:";

    public static String toAbsolutePath(String url) {
        if (url == null || !url.startsWith(HSQL_FILE_URL)) {
            return url;
        }
        String path = url.substring(HSQL_FILE_URL.length());
        File file = new File(path);
        if (!file.isAbsolute()) {
            File base = SystemInstance.get().getBase().getDirectory();
            file = new File(base, path);
        }
        path = file.getAbsolutePath();
        return HSQL_FILE_URL + path;
    }

    @Override
    public String updatedUrl(String dataSourceUrl) {
        return HsqldbDataSourcePlugin.toAbsolutePath(dataSourceUrl);
    }

    @Override
    public boolean enableUserDirHack() {
        return false;
    }
}

