/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TinkerMemory
implements Memory.Admin {
    public final Map<String, MemoryComputeKey> memoryKeys = new HashMap<String, MemoryComputeKey>();
    public Map<String, Optional<Object>> previousMap;
    public Map<String, Optional<Object>> currentMap;
    private final AtomicInteger iteration = new AtomicInteger(0);
    private final AtomicLong runtime = new AtomicLong(0L);
    private boolean inExecute = false;

    public TinkerMemory(VertexProgram<?> vertexProgram, Set<MapReduce> mapReducers) {
        this.currentMap = new ConcurrentHashMap<String, Optional<Object>>();
        this.previousMap = new ConcurrentHashMap<String, Optional<Object>>();
        if (null != vertexProgram) {
            for (MemoryComputeKey memoryComputeKey : vertexProgram.getMemoryComputeKeys()) {
                this.memoryKeys.put(memoryComputeKey.getKey(), memoryComputeKey);
            }
        }
        for (MapReduce mapReduce : mapReducers) {
            this.memoryKeys.put(mapReduce.getMemoryKey(), MemoryComputeKey.of((String)mapReduce.getMemoryKey(), (BinaryOperator)Operator.assign, (boolean)false, (boolean)false));
        }
    }

    public Set<String> keys() {
        return this.previousMap.keySet().stream().filter(key -> !this.inExecute || this.memoryKeys.get(key).isBroadcast()).collect(Collectors.toSet());
    }

    public void incrIteration() {
        this.iteration.getAndIncrement();
    }

    public void setIteration(int iteration) {
        this.iteration.set(iteration);
    }

    public int getIteration() {
        return this.iteration.get();
    }

    public void setRuntime(long runTime) {
        this.runtime.set(runTime);
    }

    public long getRuntime() {
        return this.runtime.get();
    }

    protected void complete() {
        this.iteration.decrementAndGet();
        this.previousMap = this.currentMap;
        this.memoryKeys.values().stream().filter(MemoryComputeKey::isTransient).forEach(computeKey -> this.previousMap.remove(computeKey.getKey()));
    }

    protected void completeSubRound() {
        this.previousMap = new ConcurrentHashMap<String, Optional<Object>>(this.currentMap);
        this.inExecute = !this.inExecute;
    }

    public boolean isInitialIteration() {
        return this.getIteration() == 0;
    }

    public <R> R get(String key) throws IllegalArgumentException {
        if (!this.previousMap.containsKey(key)) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        Optional<Object> o = this.previousMap.get(key);
        R r = o.orElse(null);
        if (this.inExecute && !this.memoryKeys.get(key).isBroadcast()) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        return r;
    }

    public void set(String key, Object value) {
        this.checkKeyValue(key, value);
        if (this.inExecute) {
            throw Memory.Exceptions.memorySetOnlyDuringVertexProgramSetUpAndTerminate((String)key);
        }
        this.currentMap.put(key, Optional.ofNullable(value));
    }

    public void add(String key, Object value) {
        this.checkKeyValue(key, value);
        if (!this.inExecute) {
            throw Memory.Exceptions.memoryAddOnlyDuringVertexProgramExecute((String)key);
        }
        this.currentMap.compute(key, (k, v) -> Optional.ofNullable(null == v || !v.isPresent() ? value : this.memoryKeys.get(key).getReducer().apply(v.get(), value)));
    }

    public String toString() {
        return StringFactory.memoryString((Memory)this);
    }

    protected void checkKeyValue(String key, Object value) {
        if (!this.memoryKeys.containsKey(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)key);
        }
    }
}

