/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.driver.util.ProfilingApplication;

public class ConfigurationEvaluator {
    private final List<Integer> maxConnectionPoolSizeRange = Arrays.asList(16, 32, 64, 96, 128, 192, 256, 384, 512);
    private final List<Integer> workerPoolSizeRange = Arrays.asList(1, 2, 3, 4, 8, 16, 32);
    private final List<Integer> nioPoolSizeRange = Arrays.asList(1, 2, 4);
    private final List<Integer> parallelismSizeRange = Arrays.asList(1, 2, 4, 8, 16);

    public Stream<String[]> generate(String[] args) throws Exception {
        HashSet<String> configsTried = new HashSet<String>();
        for (int ir = 0; ir < this.nioPoolSizeRange.size(); ++ir) {
            for (int is = 0; is < this.parallelismSizeRange.size(); ++is) {
                for (int it = 0; it < this.workerPoolSizeRange.size(); ++it) {
                    for (int ix = 0; ix < this.maxConnectionPoolSizeRange.size(); ++ix) {
                        String s = String.join((CharSequence)",", String.valueOf(ir), String.valueOf(is), String.valueOf(it), String.valueOf(ix));
                        if (configsTried.contains(s)) continue;
                        Object[] argsToProfiler = Stream.of("nioPoolSize", this.nioPoolSizeRange.get(ir).toString(), "parallelism", this.parallelismSizeRange.get(is).toString(), "workerPoolSize", this.workerPoolSizeRange.get(it).toString(), "maxConnectionPoolSize", this.maxConnectionPoolSizeRange.get(ix).toString(), "noExit", Boolean.TRUE.toString()).toArray();
                        Object[] withExtraArgs = args.length > 0 ? Stream.concat(Stream.of(args), Stream.of(argsToProfiler)).toArray() : argsToProfiler;
                        Object[] stringProfilerArgs = (String[])Arrays.copyOf(withExtraArgs, withExtraArgs.length, String[].class);
                        System.out.println("Testing with: " + Arrays.toString(stringProfilerArgs));
                        ProfilingApplication.main((String[])stringProfilerArgs);
                        TimeUnit.SECONDS.sleep(5L);
                        configsTried.add(s);
                    }
                }
            }
        }
        System.out.println(configsTried.size());
        return null;
    }

    public static void main(String[] args) {
        try {
            new ConfigurationEvaluator().generate(args);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

