/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

final class JavaTimeSerializersV4 {
    private JavaTimeSerializersV4() {
    }

    static final class OffsetDateTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<OffsetDateTime> {
        public OffsetDateTimeJacksonDeserializer() {
            super(OffsetDateTime.class);
        }

        @Override
        public OffsetDateTime parse(String val) {
            return OffsetDateTime.parse(val);
        }
    }

    static final class OffsetDateTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<OffsetDateTime> {
        public OffsetDateTimeJacksonSerializer() {
            super(OffsetDateTime.class);
        }
    }

    static final class DurationJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Duration> {
        public DurationJacksonDeserializer() {
            super(Duration.class);
        }

        @Override
        public Duration parse(String val) {
            return Duration.parse(val);
        }
    }

    static final class DurationJacksonSerializer
    extends AbstractJavaTimeSerializer<Duration> {
        public DurationJacksonSerializer() {
            super(Duration.class);
        }
    }

    static abstract class AbstractJavaTimeJacksonDeserializer<T>
    extends StdDeserializer<T> {
        public AbstractJavaTimeJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public abstract T parse(String var1);

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.parse(jsonParser.getText());
        }

        public boolean isCachable() {
            return true;
        }
    }

    static abstract class AbstractJavaTimeSerializer<T>
    extends StdSerializer<T> {
        public AbstractJavaTimeSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(value.toString());
        }

        public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            typeSer.writeTypePrefixForScalar(value, gen);
            gen.writeString(value.toString());
            typeSer.writeTypeSuffixForScalar(value, gen);
        }
    }
}

