/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;

public class GraphStep<S, E extends Element>
extends AbstractStep<S, E>
implements GraphComputing,
AutoCloseable,
Configuring {
    protected Parameters parameters = new Parameters();
    protected final Class<E> returnClass;
    protected GValue<?>[] ids;
    protected boolean legacyLogicForPassingNoIds = false;
    protected transient Supplier<Iterator<E>> iteratorSupplier;
    protected boolean isStart;
    protected boolean done = false;
    private Traverser.Admin<S> head = null;
    private Iterator<E> iterator = EmptyIterator.instance();

    public GraphStep(Traversal.Admin traversal, Class<E> returnClass, boolean isStart, Object ... ids) {
        super(traversal);
        this.returnClass = returnClass;
        this.ids = GValue.ensureGValues(GraphStep.tryUnrollSingleCollectionArgument(ids));
        this.isStart = isStart;
        Object[] idValues = GValue.resolveToValues(this.ids);
        this.iteratorSupplier = () -> Vertex.class.isAssignableFrom(this.returnClass) ? this.getTraversal().getGraph().get().vertices(idValues) : this.getTraversal().getGraph().get().edges(idValues);
    }

    protected static Object[] tryUnrollSingleCollectionArgument(Object[] ids) {
        Optional<Object> opt;
        Object[] tempIds = ids != null && ids.length == 1 ? ((opt = ids[0] instanceof GValue && ((GValue)ids[0]).getType().isCollection() ? Optional.of((Collection)((GValue)ids[0]).get()) : (ids[0] instanceof Collection ? Optional.of((Collection)ids[0]) : Optional.empty())).isPresent() ? ((Collection)opt.get()).toArray(new Object[((Collection)opt.get()).size()]) : ids) : ids;
        return tempIds;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids));
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(null, keyValues);
    }

    public Class<E> getReturnClass() {
        return this.returnClass;
    }

    public boolean isStartStep() {
        return this.isStart;
    }

    public static boolean isStartStep(Step<?, ?> step) {
        return step instanceof GraphStep && ((GraphStep)step).isStart;
    }

    public boolean returnsVertex() {
        return this.returnClass.equals(Vertex.class);
    }

    public boolean returnsEdge() {
        return this.returnClass.equals(Edge.class);
    }

    public void setIteratorSupplier(Supplier<Iterator<E>> iteratorSupplier) {
        this.iteratorSupplier = iteratorSupplier;
    }

    public GValue[] getIds() {
        return this.ids;
    }

    public Object[] getIdsAsValues() {
        if (this.legacyLogicForPassingNoIds) {
            return null;
        }
        return GValue.resolveToValues(this.ids);
    }

    public void addIds(Object ... newIds) {
        this.legacyLogicForPassingNoIds = newIds.length == 1 && (newIds[0] instanceof List && ((List)newIds[0]).isEmpty() || newIds[0] instanceof GValue && ((GValue)newIds[0]).getType().isCollection() && ((List)((GValue)newIds[0]).get()).isEmpty());
        Object[] gvalues = GValue.ensureGValues(GraphStep.tryUnrollSingleCollectionArgument(newIds));
        this.ids = (GValue[])ArrayUtils.addAll((Object[])this.ids, (Object[])gvalues);
    }

    public void clearIds() {
        this.ids = new GValue[0];
    }

    @Override
    public void onGraphComputer() {
        this.iteratorSupplier = Collections::emptyIterator;
        this.convertElementsToIds();
    }

    public void convertElementsToIds() {
        if (null != this.ids) {
            for (int i = 0; i < this.ids.length; ++i) {
                GValue<?> current = this.ids[i];
                if (!(current.get() instanceof Element)) continue;
                this.ids[i] = GValue.of(current.getName(), ((Element)current.get()).id());
            }
        }
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        while (!this.iterator.hasNext()) {
            if (this.isStart) {
                if (this.done) {
                    throw FastNoSuchElementException.instance();
                }
                this.done = true;
                this.iterator = null == this.iteratorSupplier ? EmptyIterator.instance() : this.iteratorSupplier.get();
                continue;
            }
            this.head = this.starts.next();
            this.iterator = null == this.iteratorSupplier ? EmptyIterator.instance() : this.iteratorSupplier.get();
        }
        return this.isStart ? this.getTraversal().getTraverserGenerator().generate((Element)this.iterator.next(), this, 1L) : this.head.split((Element)this.iterator.next(), this);
    }

    @Override
    public void reset() {
        super.reset();
        this.head = null;
        this.done = false;
        this.iterator = EmptyIterator.instance();
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.returnClass);
        if (this.ids != null) {
            for (GValue<?> id : this.ids) {
                result = 31 * result + Objects.hashCode(id);
            }
        }
        return result;
    }

    @Override
    public void close() {
        CloseableIterator.closeIterator(this.iterator);
    }

    public static boolean processHasContainerIds(GraphStep<?, ?> graphStep, HasContainer hasContainer) {
        String key = hasContainer.getKey();
        if (key != null && key.equals(T.id.getAccessor()) && graphStep.ids.length == 0 && (hasContainer.getBiPredicate() == Compare.eq || hasContainer.getBiPredicate() == Contains.within)) {
            graphStep.addIds(hasContainer.getValue());
            return true;
        }
        return false;
    }
}

