/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.DefaultGraphManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.shaded.minlog.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckedGraphManager
extends DefaultGraphManager {
    private static final Logger logger = LoggerFactory.getLogger(CheckedGraphManager.class);
    private List<StartupFailure> startupFailures;

    public CheckedGraphManager(Settings settings) {
        super(settings);
        if (this.getGraphNames().isEmpty()) {
            if (this.getStartupFailures().isEmpty()) {
                throw new IllegalStateException("No graph configured in settings:" + settings.graphs);
            }
            if (this.startupFailures.size() == 1) {
                StartupFailure failure = this.startupFailures.get(0);
                throw new IllegalStateException(failure.toString(), failure.exception);
            }
            throw new IllegalStateException("All " + this.startupFailures.size() + " graphs has failed:" + this.startupFailures, this.startupFailures.get((int)0).exception);
        }
    }

    private List<StartupFailure> getStartupFailures() {
        if (this.startupFailures == null) {
            this.startupFailures = new ArrayList<StartupFailure>();
        }
        return this.startupFailures;
    }

    @Override
    protected void addGraph(String name, String configurationFile) {
        try {
            Graph newGraph = GraphFactory.open((String)configurationFile);
            this.putGraph(name, newGraph);
            logger.info("Graph [{}] was successfully configured via [{}].", (Object)name, (Object)configurationFile);
        }
        catch (Throwable e) {
            StartupFailure failure = new StartupFailure(name, configurationFile, e);
            if (logger.isDebugEnabled()) {
                Log.debug((String)failure.toString(), (Throwable)e);
            }
            this.getStartupFailures().add(failure);
        }
    }

    private static class StartupFailure {
        private final String name;
        private final String configurationFile;
        private final Throwable exception;

        public StartupFailure(String name, String configurationFile, Throwable exception) {
            this.name = name;
            this.configurationFile = configurationFile;
            this.exception = exception;
        }

        public String toString() {
            return String.format("Graph [%s] configured at [%s] could not be instantiated and will not be available in Gremlin Server.  GraphFactory message: %s", this.name, this.configurationFile, this.exception.getMessage());
        }
    }
}

