/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.builder.AssociationRoleBuilder;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.OperationWrapper;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.builder.RemoveOnlyList;
import org.apache.sis.feature.builder.TypeBuilder;
import org.apache.sis.feature.internal.AttributeConvention;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class FeatureTypeBuilder
extends TypeBuilder {
    private final NameFactory nameFactory;
    private final List<PropertyTypeBuilder> properties;
    private final List<DefaultFeatureType> superTypes;
    private boolean isAbstract;
    private NameSpace namespace;
    int defaultMinimumOccurs;
    int defaultMaximumOccurs;
    private String idPrefix;
    private String idSuffix;
    private String idDelimiter;
    int identifierCount;
    AttributeTypeBuilder<?> defaultGeometry;
    private final Geometries<?> geometries;
    private transient DefaultFeatureType feature;

    public FeatureTypeBuilder() {
        this(null, null, null);
    }

    public FeatureTypeBuilder(DefaultFeatureType template) {
        this(null, null, null);
        if (template != null) {
            this.initialize(template);
        }
    }

    public FeatureTypeBuilder(NameFactory factory, GeometryLibrary library, Locale locale) {
        super(locale);
        if (factory == null) {
            factory = DefaultNameFactory.provider();
        }
        this.nameFactory = factory;
        this.geometries = Geometries.factory(library);
        this.properties = new ArrayList<PropertyTypeBuilder>();
        this.superTypes = new ArrayList<DefaultFeatureType>();
        this.idDelimiter = ":";
        this.defaultMinimumOccurs = 1;
        this.defaultMaximumOccurs = 1;
    }

    public FeatureTypeBuilder clear() {
        this.reset();
        this.properties.clear();
        this.superTypes.clear();
        this.isAbstract = false;
        this.namespace = null;
        this.defaultMinimumOccurs = 1;
        this.defaultMaximumOccurs = 1;
        this.idPrefix = null;
        this.idSuffix = null;
        this.idDelimiter = ":";
        this.identifierCount = 0;
        this.defaultGeometry = null;
        this.clearCache();
        return this;
    }

    public FeatureTypeBuilder setAll(DefaultFeatureType template) {
        this.clear();
        if (template != null) {
            this.initialize(template);
        }
        return this;
    }

    private void initialize(DefaultFeatureType template) {
        super.initialize(template);
        this.feature = template;
        this.isAbstract = template.isAbstract();
        this.superTypes.addAll(template.getSuperTypes());
        HashMap<String, Set> propertyRoles = new HashMap<String, Set>();
        for (AbstractIdentifiedType abstractIdentifiedType : template.getProperties(false)) {
            AttributeRole role;
            PropertyTypeBuilder builder = abstractIdentifiedType instanceof DefaultAttributeType ? new AttributeTypeBuilder(this, (DefaultAttributeType)abstractIdentifiedType) : (abstractIdentifiedType instanceof DefaultAssociationRole ? new AssociationRoleBuilder(this, (DefaultAssociationRole)abstractIdentifiedType) : null);
            GenericName name = abstractIdentifiedType.getName();
            if (AttributeConvention.IDENTIFIER_PROPERTY.equals(name)) {
                role = AttributeRole.IDENTIFIER_COMPONENT;
            } else if (AttributeConvention.GEOMETRY_PROPERTY.equals(name)) {
                role = AttributeRole.DEFAULT_GEOMETRY;
            } else if (AttributeConvention.ENVELOPE_PROPERTY.equals(name)) {
                role = null;
            } else {
                if (builder == null) {
                    builder = new OperationWrapper(this, abstractIdentifiedType);
                }
                role = null;
            }
            if (role != null) {
                Set<AttributeRole> rc = Set.of(role);
                if (abstractIdentifiedType instanceof AbstractOperation) {
                    for (String dependency : ((AbstractOperation)abstractIdentifiedType).getDependencies()) {
                        propertyRoles.merge(dependency, rc, AttributeRole::merge);
                    }
                } else {
                    propertyRoles.merge(name.toString(), rc, AttributeRole::merge);
                }
            }
            if (builder == null) continue;
            this.properties.add(builder);
        }
        if (!propertyRoles.isEmpty()) {
            for (Map.Entry entry : propertyRoles.entrySet()) {
                PropertyTypeBuilder property = this.forName(this.properties, (String)entry.getKey(), true);
                if (!(property instanceof AttributeTypeBuilder)) continue;
                ((AttributeTypeBuilder)property).roles().addAll((Collection)entry.getValue());
            }
        }
    }

    @Override
    final void clearCache() {
        this.feature = null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public FeatureTypeBuilder setAbstract(boolean isAbstract) {
        if (this.isAbstract != isAbstract) {
            this.isAbstract = isAbstract;
            this.clearCache();
        }
        return this;
    }

    public DefaultFeatureType[] getSuperTypes() {
        return (DefaultFeatureType[])this.superTypes.toArray(DefaultFeatureType[]::new);
    }

    public FeatureTypeBuilder setSuperTypes(DefaultFeatureType ... parents) {
        this.ensureNonNull("parents", parents);
        List<DefaultFeatureType> asList = Arrays.asList(parents);
        if (!this.superTypes.equals(asList)) {
            this.superTypes.clear();
            this.superTypes.addAll(asList);
            int i = this.superTypes.size();
            while (--i >= 0) {
                if (this.superTypes.get(i) != null) continue;
                this.superTypes.remove(i);
            }
            this.clearCache();
        }
        return this;
    }

    public CharSequence getNameSpace() {
        return this.namespace != null ? this.namespace.name().toString() : null;
    }

    public FeatureTypeBuilder setNameSpace(CharSequence ns) {
        this.namespace = ns != null && ns.length() != 0 ? this.nameFactory.createNameSpace(this.nameFactory.createLocalName(null, ns), null) : null;
        return this;
    }

    @Override
    public FeatureTypeBuilder setName(GenericName name) {
        super.setName(name);
        return this;
    }

    @Override
    public FeatureTypeBuilder setName(CharSequence localPart) {
        super.setName(localPart);
        return this;
    }

    @Override
    public FeatureTypeBuilder setName(CharSequence ... components) {
        super.setName(components);
        return this;
    }

    @Override
    final GenericName createLocalName(CharSequence name) {
        return this.nameFactory.createLocalName(this.namespace, name);
    }

    @Override
    final GenericName createGenericName(CharSequence ... names) {
        return this.nameFactory.createGenericName(this.namespace, names);
    }

    public FeatureTypeBuilder setDefaultMultiplicity(int minimumOccurs, int maximumOccurs) {
        if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
            throw new IllegalArgumentException(this.errors().getString((short)60, minimumOccurs, maximumOccurs));
        }
        this.defaultMinimumOccurs = minimumOccurs;
        this.defaultMaximumOccurs = maximumOccurs;
        return this;
    }

    public FeatureTypeBuilder setIdentifierDelimiters(String delimiter, String prefix, String suffix) {
        this.ensureNonEmpty("delimiter", delimiter);
        if (!(delimiter.equals(this.idDelimiter) && Objects.equals(prefix, this.idPrefix) && Objects.equals(suffix, this.idSuffix))) {
            this.idDelimiter = delimiter;
            this.idPrefix = prefix;
            this.idSuffix = suffix;
            this.clearCache();
        }
        return this;
    }

    public List<PropertyTypeBuilder> properties() {
        return new RemoveOnlyList<PropertyTypeBuilder>(this.properties);
    }

    public boolean isNameUsed(String name) {
        return this.forName(this.properties, name, false) != null;
    }

    public PropertyTypeBuilder getProperty(String name) {
        return this.forName(this.properties, name, true);
    }

    public <V> AttributeTypeBuilder<V> addAttribute(Class<V> valueClass) {
        this.ensureNonNull("valueClass", valueClass);
        if (AbstractFeature.class.isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException(this.errors().getString((short)45, "valueClass", valueClass));
        }
        AttributeTypeBuilder<V> property = new AttributeTypeBuilder<V>(this, Numbers.primitiveToWrapper(valueClass));
        this.properties.add(property);
        this.clearCache();
        return property;
    }

    public <V> AttributeTypeBuilder<V> addAttribute(DefaultAttributeType<V> template) {
        this.ensureNonNull("template", template);
        AttributeTypeBuilder<V> property = new AttributeTypeBuilder<V>(this, template);
        this.properties.add(property);
        this.clearCache();
        return property;
    }

    public AttributeTypeBuilder<?> addAttribute(GeometryType type) {
        Class<Object> c;
        this.ensureNonNull("type", type);
        if (type.equals(GeometryType.POINT)) {
            c = this.geometries.pointClass;
        } else if (type.equals(GeometryType.LINEAR)) {
            c = this.geometries.polylineClass;
        } else if (type.equals(GeometryType.AREAL)) {
            c = this.geometries.polygonClass;
        } else {
            throw new IllegalArgumentException(this.errors().getString((short)170, type));
        }
        return this.addAttribute(c);
    }

    public AssociationRoleBuilder addAssociation(DefaultFeatureType type) {
        this.ensureNonNull("type", type);
        AssociationRoleBuilder property = new AssociationRoleBuilder(this, type, type.getName());
        this.properties.add(property);
        this.clearCache();
        return property;
    }

    public AssociationRoleBuilder addAssociation(GenericName type) {
        this.ensureNonNull("type", type);
        AssociationRoleBuilder property = new AssociationRoleBuilder(this, null, type);
        this.properties.add(property);
        this.clearCache();
        return property;
    }

    public AssociationRoleBuilder addAssociation(DefaultAssociationRole template) {
        this.ensureNonNull("template", template);
        AssociationRoleBuilder property = new AssociationRoleBuilder(this, template);
        this.properties.add(property);
        this.clearCache();
        return property;
    }

    public PropertyTypeBuilder addProperty(AbstractIdentifiedType template) {
        this.ensureNonNull("template", template);
        if (template instanceof DefaultAttributeType) {
            return this.addAttribute((DefaultAttributeType)template);
        }
        if (template instanceof DefaultAssociationRole) {
            return this.addAssociation((DefaultAssociationRole)template);
        }
        OperationWrapper property = new OperationWrapper(this, template);
        this.properties.add(property);
        this.clearCache();
        return property;
    }

    @Override
    public FeatureTypeBuilder setDefinition(CharSequence definition) {
        super.setDefinition(definition);
        return this;
    }

    @Override
    public FeatureTypeBuilder setDesignation(CharSequence designation) {
        super.setDesignation(designation);
        return this;
    }

    @Override
    public FeatureTypeBuilder setDescription(CharSequence description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public FeatureTypeBuilder setDeprecated(boolean deprecated) {
        super.setDeprecated(deprecated);
        return this;
    }

    @Override
    public DefaultFeatureType build() throws IllegalStateException {
        if (this.feature == null) {
            AbstractIdentifiedType[] identifierTypes;
            int numSynthetic;
            int numSpecified = this.properties.size();
            int envelopeIndex = -1;
            int geometryIndex = -1;
            if (this.identifierCount == 0) {
                numSynthetic = 0;
                identifierTypes = null;
            } else {
                numSynthetic = 1;
                identifierTypes = new AbstractIdentifiedType[this.identifierCount];
            }
            if (this.defaultGeometry != null) {
                envelopeIndex = numSynthetic++;
                if (!AttributeConvention.GEOMETRY_PROPERTY.equals(this.defaultGeometry.getName())) {
                    geometryIndex = numSynthetic++;
                }
            }
            AbstractIdentifiedType[] propertyTypes = new AbstractIdentifiedType[numSynthetic + numSpecified];
            int propertyCursor = numSynthetic;
            int identifierCursor = 0;
            for (int i = 0; i < numSpecified; ++i) {
                AbstractIdentifiedType instance;
                PropertyTypeBuilder builder = this.properties.get(i);
                propertyTypes[propertyCursor] = instance = builder.build();
                if (builder.isIdentifier()) {
                    identifierTypes[identifierCursor++] = instance;
                }
                if (builder == this.defaultGeometry && geometryIndex >= 0) {
                    if (propertyTypes[geometryIndex] != null) {
                        throw new CorruptedObjectException();
                    }
                    propertyTypes[geometryIndex] = FeatureOperations.link(FeatureTypeBuilder.name(AttributeConvention.GEOMETRY_PROPERTY), instance);
                }
                ++propertyCursor;
            }
            if (envelopeIndex >= 0) {
                try {
                    propertyTypes[envelopeIndex] = FeatureOperations.envelope(FeatureTypeBuilder.name(AttributeConvention.ENVELOPE_PROPERTY), null, propertyTypes);
                }
                catch (FactoryException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (identifierTypes != null) {
                if (identifierCursor != identifierTypes.length) {
                    throw new CorruptedObjectException();
                }
                if (AttributeConvention.IDENTIFIER_PROPERTY.equals(identifierTypes[0].getName())) {
                    if (identifierCursor > 1) {
                        throw new IllegalStateException(Resources.format((short)58, this.getDisplayName(), AttributeConvention.IDENTIFIER_PROPERTY));
                    }
                    System.arraycopy(propertyTypes, 1, propertyTypes, 0, --propertyCursor);
                } else {
                    propertyTypes[0] = FeatureOperations.compound(FeatureTypeBuilder.name(AttributeConvention.IDENTIFIER_PROPERTY), this.idDelimiter, this.idPrefix, this.idSuffix, identifierTypes);
                }
            }
            this.feature = new DefaultFeatureType(this.identification(), this.isAbstract(), (DefaultFeatureType[])this.superTypes.toArray(DefaultFeatureType[]::new), ArraysExt.resize(propertyTypes, propertyCursor));
        }
        return this.feature;
    }

    private static Map<String, ?> name(GenericName name) {
        return Map.of("name", name);
    }

    final void replace(PropertyTypeBuilder old, PropertyTypeBuilder replacement) {
        int index = this.properties.lastIndexOf(old);
        if (index < 0 || (replacement != null ? this.properties.set(index, replacement) : this.properties.remove(index)) != old) {
            throw new CorruptedObjectException();
        }
        if (old == this.defaultGeometry) {
            this.defaultGeometry = (AttributeTypeBuilder)replacement;
        }
        this.clearCache();
    }

    @Override
    final void toStringInternal(StringBuilder buffer) {
        if (this.isAbstract()) {
            buffer.insert(buffer.indexOf("[") + 1, "abstract ");
        }
        String separator = " : ";
        for (DefaultFeatureType parent : this.superTypes) {
            buffer.append(separator).append('\u201c').append(parent.getName()).append('\u201d');
            separator = ", ";
        }
        buffer.append(" {");
        separator = System.lineSeparator();
        for (PropertyTypeBuilder p : this.properties) {
            p.appendStringTo(buffer.append(separator).append("    ").append(p.getClass().getSimpleName()));
        }
        buffer.append(separator).append('}');
    }
}

