/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.utils.Util;

public class CoCodeBinPacking
extends AColumnCoCoder {
    private static final boolean FIRST_FIT_DEC = true;
    private static final int MAX_COL_FIRST_FIT = 16384;
    private static final int MAX_COL_PER_GROUP = 1024;
    private final Memorizer mem = new Memorizer();
    public static double BIN_CAPACITY = 3.2E-5;

    protected CoCodeBinPacking(CompressedSizeEstimator sizeEstimator, ICostEstimate costEstimator, CompressionSettings cs) {
        super(sizeEstimator, costEstimator, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        ArrayList<CompressedSizeInfoColGroup> constantGroups = new ArrayList<CompressedSizeInfoColGroup>();
        ArrayList<CompressedSizeInfoColGroup> newGroups = new ArrayList<CompressedSizeInfoColGroup>();
        for (CompressedSizeInfoColGroup g : colInfos.getInfo()) {
            if (g.getBestCompressionType(this._cs) == AColGroup.CompressionType.CONST) {
                constantGroups.add(g);
                continue;
            }
            this.mem.put(g);
            newGroups.add(g);
        }
        colInfos.setInfo(this.partitionColumns(newGroups));
        this.getCoCodingGroupsBruteForce(colInfos, k);
        colInfos.getInfo().addAll(constantGroups);
        return colInfos;
    }

    private List<CompressedSizeInfoColGroup> partitionColumns(List<CompressedSizeInfoColGroup> currentGroups) {
        ArrayList<CompressedSizeInfoColGroup> bins = new ArrayList<CompressedSizeInfoColGroup>();
        for (int i = 0; i < currentGroups.size(); i += 16384) {
            int iu = Math.min(i + 16384, currentGroups.size());
            List<CompressedSizeInfoColGroup> currentGroupsSubset = currentGroups.subList(i, iu);
            currentGroupsSubset.sort(new Comparator<CompressedSizeInfoColGroup>(){

                @Override
                public int compare(CompressedSizeInfoColGroup a, CompressedSizeInfoColGroup b) {
                    double bc;
                    double ac = a.getCardinalityRatio();
                    if (ac == (bc = b.getCardinalityRatio())) {
                        return 0;
                    }
                    if (ac > bc) {
                        return 1;
                    }
                    return -1;
                }
            });
            bins.addAll(this.packFirstFit(currentGroupsSubset));
        }
        return bins;
    }

    private List<CompressedSizeInfoColGroup> packFirstFit(List<CompressedSizeInfoColGroup> currentGroups) {
        ArrayList<CompressedSizeInfoColGroup> bins = new ArrayList<CompressedSizeInfoColGroup>();
        double[] binWeights = new double[16];
        for (int i = 0; i < currentGroups.size(); ++i) {
            CompressedSizeInfoColGroup c = currentGroups.get(i);
            boolean assigned = false;
            for (int j = 0; j < bins.size(); ++j) {
                double newBinWeight = binWeights[j] - c.getCardinalityRatio();
                if (!(newBinWeight >= 0.0) || ((CompressedSizeInfoColGroup)bins.get(j)).getColumns().length >= 1023) continue;
                bins.set(j, this.joinWithoutAnalysis(Util.join(((CompressedSizeInfoColGroup)bins.get(j)).getColumns(), c.getColumns()), (CompressedSizeInfoColGroup)bins.get(j), c));
                binWeights[j] = newBinWeight;
                assigned = true;
                break;
            }
            if (assigned) continue;
            if (bins.size() == binWeights.length) {
                binWeights = Arrays.copyOf(binWeights, 2 * binWeights.length);
            }
            bins.add(c);
            binWeights[bins.size() - 1] = BIN_CAPACITY - c.getCardinalityRatio();
        }
        return bins;
    }

    private CompressedSizeInfo getCoCodingGroupsBruteForce(CompressedSizeInfo bins, int k) {
        ArrayList<CompressedSizeInfoColGroup> finalGroups = new ArrayList<CompressedSizeInfoColGroup>();
        for (CompressedSizeInfoColGroup bin : bins.getInfo()) {
            int len = bin.getColumns().length;
            if (len == 0) continue;
            if (len == 1) {
                finalGroups.add(bin);
                continue;
            }
            finalGroups.addAll(this.coCodeBruteForce(bin));
        }
        bins.setInfo(finalGroups);
        return bins;
    }

    private List<CompressedSizeInfoColGroup> coCodeBruteForce(CompressedSizeInfoColGroup bin) {
        ArrayList<int[]> workset = new ArrayList<int[]>(bin.getColumns().length);
        for (int i = 0; i < bin.getColumns().length; ++i) {
            workset.add(new int[]{bin.getColumns()[i]});
        }
        while (workset.size() > 1) {
            long changeInSize = 0L;
            CompressedSizeInfoColGroup tmp = null;
            int[] selected1 = null;
            int[] selected2 = null;
            for (int i = 0; i < workset.size(); ++i) {
                for (int j = i + 1; j < workset.size(); ++j) {
                    int[] c1 = (int[])workset.get(i);
                    int[] c2 = (int[])workset.get(j);
                    long sizeC1 = this.mem.get(c1).getMinSize();
                    long sizeC2 = this.mem.get(c2).getMinSize();
                    this.mem.incst1();
                    if (-Math.min(sizeC1, sizeC2) > changeInSize) continue;
                    CompressedSizeInfoColGroup c1c2Inf = this.mem.getOrCreate(c1, c2);
                    long sizeC1C2 = c1c2Inf.getMinSize();
                    long newSizeChangeIfSelected = sizeC1C2 - sizeC1 - sizeC2;
                    if ((tmp != null || newSizeChangeIfSelected >= changeInSize) && (tmp == null || newSizeChangeIfSelected >= changeInSize && (newSizeChangeIfSelected != changeInSize || c1c2Inf.getColumns().length >= tmp.getColumns().length))) continue;
                    changeInSize = newSizeChangeIfSelected;
                    tmp = c1c2Inf;
                    selected1 = c1;
                    selected2 = c2;
                }
            }
            if (tmp == null) break;
            workset.remove(selected1);
            workset.remove(selected2);
            workset.add(tmp.getColumns());
        }
        LOG.debug((Object)this.mem.stats());
        this.mem.resetStats();
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>(workset.size());
        for (int[] w : workset) {
            ret.add(this.mem.get(w));
        }
        return ret;
    }

    private static class ColIndexes {
        final int[] _indexes;

        public ColIndexes(int[] indexes) {
            this._indexes = indexes;
        }

        public int hashCode() {
            return Arrays.hashCode(this._indexes);
        }

        public boolean equals(Object that) {
            ColIndexes thatGrp = (ColIndexes)that;
            return Arrays.equals(this._indexes, thatGrp._indexes);
        }
    }

    protected class Memorizer {
        private final Map<ColIndexes, CompressedSizeInfoColGroup> mem = new HashMap<ColIndexes, CompressedSizeInfoColGroup>();
        private int st1 = 0;
        private int st2 = 0;
        private int st3 = 0;
        private int st4 = 0;

        public void put(CompressedSizeInfoColGroup g) {
            this.mem.put(new ColIndexes(g.getColumns()), g);
        }

        public CompressedSizeInfoColGroup get(CompressedSizeInfoColGroup g) {
            return this.mem.get(new ColIndexes(g.getColumns()));
        }

        public CompressedSizeInfoColGroup get(int[] c) {
            return this.mem.get(new ColIndexes(c));
        }

        public CompressedSizeInfoColGroup getOrCreate(int[] c1, int[] c2) {
            int[] c = Util.join(c1, c2);
            ColIndexes cI = new ColIndexes(Util.join(c1, c2));
            CompressedSizeInfoColGroup g = this.mem.get(cI);
            ++this.st2;
            if (g == null) {
                boolean rightConst;
                CompressedSizeInfoColGroup left = this.mem.get(new ColIndexes(c1));
                CompressedSizeInfoColGroup right = this.mem.get(new ColIndexes(c2));
                boolean leftConst = left.getBestCompressionType(CoCodeBinPacking.this._cs) == AColGroup.CompressionType.CONST && left.getNumOffs() == 0;
                boolean bl = rightConst = right.getBestCompressionType(CoCodeBinPacking.this._cs) == AColGroup.CompressionType.CONST && right.getNumOffs() == 0;
                if (leftConst) {
                    g = CompressedSizeInfoColGroup.addConstGroup(c, right, CoCodeBinPacking.this._cs.validCompressions);
                } else if (rightConst) {
                    g = CompressedSizeInfoColGroup.addConstGroup(c, left, CoCodeBinPacking.this._cs.validCompressions);
                } else {
                    ++this.st3;
                    g = CoCodeBinPacking.this._sest.estimateJoinCompressedSize(c, left, right);
                }
                if (leftConst || rightConst) {
                    ++this.st4;
                }
                this.mem.put(cI, g);
            }
            return g;
        }

        public void incst1() {
            ++this.st1;
        }

        public String stats() {
            return this.st1 + " " + this.st2 + " " + this.st3 + " " + this.st4;
        }

        public void resetStats() {
            this.st1 = 0;
            this.st2 = 0;
            this.st3 = 0;
            this.st4 = 0;
        }

        public String toString() {
            return this.mem.toString();
        }
    }
}

