/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.distributed.proxy.RemoteAsyncBucketBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface AsyncProxyManager<K> {
    public RemoteAsyncBucketBuilder<K> builder();

    public CompletableFuture<Void> removeProxy(K var1);

    public CompletableFuture<Optional<BucketConfiguration>> getProxyConfiguration(K var1);

    default public <K1> AsyncProxyManager<K1> withMapper(final Function<? super K1, ? extends K> mapper) {
        return new AsyncProxyManager<K1>(){

            @Override
            public RemoteAsyncBucketBuilder<K1> builder() {
                return AsyncProxyManager.this.builder().withMapper(mapper);
            }

            @Override
            public CompletableFuture<Void> removeProxy(K1 key) {
                return AsyncProxyManager.this.removeProxy(mapper.apply(key));
            }

            @Override
            public CompletableFuture<Optional<BucketConfiguration>> getProxyConfiguration(K1 key) {
                return AsyncProxyManager.this.getProxyConfiguration(mapper.apply(key));
            }

            @Override
            public <K2> AsyncProxyManager<K2> withMapper(Function<? super K2, ? extends K1> innerMapper) {
                return AsyncProxyManager.this.withMapper(mapper.compose(innerMapper));
            }
        };
    }
}

