/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;

public class AccessTokenLogic
extends AbstractTransactionalLogic<AccessTokenTO> {
    protected final SecurityProperties securityProperties;
    protected final EncryptorManager encryptorManager;
    protected final AccessTokenDataBinder binder;
    protected final AccessTokenDAO accessTokenDAO;

    public AccessTokenLogic(SecurityProperties securityProperties, EncryptorManager encryptorManager, AccessTokenDataBinder binder, AccessTokenDAO accessTokenDAO) {
        this.securityProperties = securityProperties;
        this.encryptorManager = encryptorManager;
        this.binder = binder;
        this.accessTokenDAO = accessTokenDAO;
    }

    protected byte[] getAuthorities() {
        byte[] authorities = null;
        try {
            authorities = this.encryptorManager.getInstance().encode(POJOHelper.serialize((Object)AuthContextUtils.getAuthorities()), CipherAlgorithm.AES).getBytes();
        }
        catch (Exception e) {
            LOG.error("Could not fetch authorities", (Throwable)e);
        }
        return authorities;
    }

    @PreAuthorize(value="isAuthenticated()")
    public AccessTokenDataBinder.AccessTokenInfo login() {
        if (this.securityProperties.getAnonymousUser().equals(AuthContextUtils.getUsername())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(this.securityProperties.getAnonymousUser() + " cannot be granted an access token");
            throw sce;
        }
        return this.binder.create(Optional.empty(), AuthContextUtils.getUsername(), Map.of(), this.getAuthorities(), false);
    }

    @PreAuthorize(value="isAuthenticated()")
    public AccessTokenDataBinder.AccessTokenInfo refresh() {
        AccessToken accessToken = (AccessToken)this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("AccessToken for " + AuthContextUtils.getUsername()));
        return this.binder.update(accessToken, this.getAuthorities());
    }

    @PreAuthorize(value="isAuthenticated()")
    public void logout() {
        AccessToken accessToken = (AccessToken)this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("AccessToken for " + AuthContextUtils.getUsername()));
        this.delete(accessToken.getKey());
    }

    @PreAuthorize(value="hasRole('ACCESS_TOKEN_LIST')")
    public Page<AccessTokenTO> list(Pageable pageable) {
        return this.accessTokenDAO.findAll(pageable).map(arg_0 -> ((AccessTokenDataBinder)this.binder).getAccessTokenTO(arg_0));
    }

    @PreAuthorize(value="hasRole('ACCESS_TOKEN_DELETE')")
    public void delete(String key) {
        this.accessTokenDAO.deleteById(key);
    }

    @Override
    protected AccessTokenTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

