/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.DatabaseIdProvider;

public class VendorDatabaseIdProvider
implements DatabaseIdProvider {
    private Properties properties;

    @Override
    public String getDatabaseId(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource cannot be null");
        }
        try {
            return this.getDatabaseName(dataSource);
        }
        catch (SQLException e) {
            throw new BuilderException("Error occurred when getting DB product name.", e);
        }
    }

    @Override
    public void setProperties(Properties p) {
        this.properties = p;
    }

    private String getDatabaseName(DataSource dataSource) throws SQLException {
        String productName = this.getDatabaseProductName(dataSource);
        if (this.properties == null || this.properties.isEmpty()) {
            return productName;
        }
        return this.properties.entrySet().stream().filter(entry -> productName.contains((String)entry.getKey())).map(entry -> (String)entry.getValue()).findFirst().orElse(null);
    }

    private String getDatabaseProductName(DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            String string = con.getMetaData().getDatabaseProductName();
            return string;
        }
    }
}

