/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventDeploymentBuilder;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.EventRepositoryServiceImpl;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntityManager;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class EventDeploymentBuilderImpl
implements EventDeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient EventRepositoryServiceImpl repositoryService;
    protected transient EventResourceEntityManager resourceEntityManager;
    protected EventDeploymentEntity deployment;
    protected boolean isDuplicateFilterEnabled;

    public EventDeploymentBuilderImpl() {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        this.repositoryService = (EventRepositoryServiceImpl)eventRegistryEngineConfiguration.getEventRepositoryService();
        this.deployment = (EventDeploymentEntity)eventRegistryEngineConfiguration.getDeploymentEntityManager().create();
        this.resourceEntityManager = eventRegistryEngineConfiguration.getResourceEntityManager();
    }

    public EventDeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        if (inputStream == null) {
            throw new FlowableException("inputStream for resource '" + resourceName + "' is null");
        }
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new FlowableException("could not get byte array from resource '" + resourceName + "'", (Throwable)e);
        }
        if (bytes == null) {
            throw new FlowableException("byte array for resource '" + resourceName + "' is null");
        }
        EventResourceEntity resource = (EventResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    public EventDeploymentBuilder addClasspathResource(String resource) {
        EventDeploymentBuilder eventDeploymentBuilder;
        block9: {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
            try {
                if (inputStream == null) {
                    throw new FlowableException("resource '" + resource + "' not found");
                }
                eventDeploymentBuilder = this.addInputStream(resource, inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new FlowableException("Failed to read resource " + resource, (Throwable)ex);
                }
            }
            inputStream.close();
        }
        return eventDeploymentBuilder;
    }

    public EventDeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new FlowableException("text is null");
        }
        EventResourceEntity resource = (EventResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(text.getBytes(StandardCharsets.UTF_8));
        this.deployment.addResource(resource);
        return this;
    }

    public EventDeploymentBuilder addEventDefinitionBytes(String resourceName, byte[] eventDefinitionBytes) {
        if (eventDefinitionBytes == null) {
            throw new FlowableException("event definition bytes is null");
        }
        EventResourceEntity resource = (EventResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(eventDefinitionBytes);
        this.deployment.addResource(resource);
        return this;
    }

    public EventDeploymentBuilder addEventDefinition(String resourceName, String eventDefinition) {
        this.addString(resourceName, eventDefinition);
        return this;
    }

    public EventDeploymentBuilder addChannelDefinitionBytes(String resourceName, byte[] channelDefinitionBytes) {
        if (channelDefinitionBytes == null) {
            throw new FlowableException("channel definition bytes is null");
        }
        EventResourceEntity resource = (EventResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(channelDefinitionBytes);
        this.deployment.addResource(resource);
        return this;
    }

    public EventDeploymentBuilder addChannelDefinition(String resourceName, String channelDefinition) {
        this.addString(resourceName, channelDefinition);
        return this;
    }

    public EventDeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    public EventDeploymentBuilder category(String category) {
        this.deployment.setCategory(category);
        return this;
    }

    public EventDeploymentBuilder tenantId(String tenantId) {
        this.deployment.setTenantId(tenantId);
        return this;
    }

    public EventDeploymentBuilder parentDeploymentId(String parentDeploymentId) {
        this.deployment.setParentDeploymentId(parentDeploymentId);
        return this;
    }

    public EventDeploymentBuilder enableDuplicateFiltering() {
        this.isDuplicateFilterEnabled = true;
        return this;
    }

    public EventDeployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public EventDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }
}

