/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.migration;

import java.util.Map;
import org.flowable.batch.api.Batch;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationDocumentBuilderImpl;
import org.flowable.engine.migration.ActivityMigrationMapping;
import org.flowable.engine.migration.EnableActivityMapping;
import org.flowable.engine.migration.ProcessInstanceMigrationBuilder;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationValidationResult;
import org.flowable.engine.migration.Script;

public class ProcessInstanceMigrationBuilderImpl
implements ProcessInstanceMigrationBuilder {
    protected ProcessMigrationService processInstanceMigrationService;
    protected ProcessInstanceMigrationDocumentBuilderImpl migrationDocumentBuilder = new ProcessInstanceMigrationDocumentBuilderImpl();

    public ProcessInstanceMigrationBuilderImpl(ProcessMigrationService processInstanceMigrationService) {
        this.processInstanceMigrationService = processInstanceMigrationService;
    }

    @Override
    public ProcessInstanceMigrationBuilder fromProcessInstanceMigrationDocument(ProcessInstanceMigrationDocument document) {
        this.migrationDocumentBuilder.setProcessDefinitionToMigrateTo(document.getMigrateToProcessDefinitionId());
        this.migrationDocumentBuilder.setProcessDefinitionToMigrateTo(document.getMigrateToProcessDefinitionKey(), document.getMigrateToProcessDefinitionVersion());
        this.migrationDocumentBuilder.setTenantId(document.getMigrateToProcessDefinitionTenantId());
        this.migrationDocumentBuilder.addActivityMigrationMappings(document.getActivityMigrationMappings());
        this.migrationDocumentBuilder.setPreUpgradeScript(document.getPreUpgradeScript());
        this.migrationDocumentBuilder.setPreUpgradeJavaDelegate(document.getPreUpgradeJavaDelegate());
        this.migrationDocumentBuilder.setPreUpgradeJavaDelegateExpression(document.getPreUpgradeJavaDelegateExpression());
        this.migrationDocumentBuilder.setPostUpgradeScript(document.getPostUpgradeScript());
        this.migrationDocumentBuilder.setPostUpgradeJavaDelegate(document.getPostUpgradeJavaDelegate());
        this.migrationDocumentBuilder.setPostUpgradeJavaDelegateExpression(document.getPostUpgradeJavaDelegateExpression());
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder migrateToProcessDefinition(String processDefinitionId) {
        this.migrationDocumentBuilder.setProcessDefinitionToMigrateTo(processDefinitionId);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder migrateToProcessDefinition(String processDefinitionKey, int processDefinitionVersion) {
        this.migrationDocumentBuilder.setProcessDefinitionToMigrateTo(processDefinitionKey, processDefinitionVersion);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder migrateToProcessDefinition(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId) {
        this.migrationDocumentBuilder.setProcessDefinitionToMigrateTo(processDefinitionKey, processDefinitionVersion);
        this.migrationDocumentBuilder.setTenantId(processDefinitionTenantId);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder withMigrateToProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.migrationDocumentBuilder.setTenantId(processDefinitionTenantId);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder preUpgradeScript(Script script) {
        this.migrationDocumentBuilder.setPreUpgradeScript(script);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder preUpgradeJavaDelegate(String javaDelegateClassName) {
        this.migrationDocumentBuilder.setPreUpgradeJavaDelegate(javaDelegateClassName);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder preUpgradeJavaDelegateExpression(String expression) {
        this.migrationDocumentBuilder.setPreUpgradeJavaDelegateExpression(expression);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder postUpgradeScript(Script script) {
        this.migrationDocumentBuilder.setPostUpgradeScript(script);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder postUpgradeJavaDelegate(String javaDelegateClassName) {
        this.migrationDocumentBuilder.setPostUpgradeJavaDelegate(javaDelegateClassName);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder postUpgradeJavaDelegateExpression(String expression) {
        this.migrationDocumentBuilder.setPostUpgradeJavaDelegateExpression(expression);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder addActivityMigrationMapping(ActivityMigrationMapping mapping) {
        this.migrationDocumentBuilder.addActivityMigrationMapping(mapping);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder addEnableEventSubProcessStartEvent(EnableActivityMapping mapping) {
        this.migrationDocumentBuilder.addEnableActivityMapping(mapping);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder withProcessInstanceVariable(String variableName, Object variableValue) {
        this.migrationDocumentBuilder.processInstanceVariables.put(variableName, variableValue);
        return this;
    }

    @Override
    public ProcessInstanceMigrationBuilder withProcessInstanceVariables(Map<String, Object> variables) {
        this.migrationDocumentBuilder.processInstanceVariables.putAll(variables);
        return this;
    }

    @Override
    public ProcessInstanceMigrationDocument getProcessInstanceMigrationDocument() {
        return this.migrationDocumentBuilder.build();
    }

    @Override
    public void migrate(String processInstanceId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        this.getProcessMigrationService().migrateProcessInstance(processInstanceId, document);
    }

    @Override
    public ProcessInstanceMigrationValidationResult validateMigration(String processInstanceId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        return this.getProcessMigrationService().validateMigrationForProcessInstance(processInstanceId, document);
    }

    @Override
    public void migrateProcessInstances(String processDefinitionId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        this.getProcessMigrationService().migrateProcessInstancesOfProcessDefinition(processDefinitionId, document);
    }

    @Override
    public ProcessInstanceMigrationValidationResult validateMigrationOfProcessInstances(String processDefinitionId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        return this.getProcessMigrationService().validateMigrationForProcessInstancesOfProcessDefinition(processDefinitionId, document);
    }

    @Override
    public void migrateProcessInstances(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        this.getProcessMigrationService().migrateProcessInstancesOfProcessDefinition(processDefinitionKey, processDefinitionVersion, processDefinitionTenantId, document);
    }

    @Override
    public Batch batchMigrateProcessInstances(String processDefinitionId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        return this.getProcessMigrationService().batchMigrateProcessInstancesOfProcessDefinition(processDefinitionId, document);
    }

    @Override
    public Batch batchMigrateProcessInstances(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        return this.getProcessMigrationService().batchMigrateProcessInstancesOfProcessDefinition(processDefinitionKey, processDefinitionVersion, processDefinitionTenantId, document);
    }

    @Override
    public ProcessInstanceMigrationValidationResult validateMigrationOfProcessInstances(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId) {
        ProcessInstanceMigrationDocument document = this.migrationDocumentBuilder.build();
        return this.getProcessMigrationService().validateMigrationForProcessInstancesOfProcessDefinition(processDefinitionKey, processDefinitionVersion, processDefinitionTenantId, document);
    }

    protected ProcessMigrationService getProcessMigrationService() {
        if (this.processInstanceMigrationService == null) {
            throw new FlowableException("ProcessInstanceMigrationService cannot be null, Obtain your builder instance from the ProcessInstanceMigrationService to access this feature");
        }
        return this.processInstanceMigrationService;
    }
}

