/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.messaging.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.error.TypedMessageErrorHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.util.SOAPSupport;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;

public class SOAP11FaultContextDecoratingErrorHandler
implements TypedMessageErrorHandler {
    @Nonnull
    private Class<? extends Throwable> handledThrowable;
    @Nonnull
    private QName faultCode;
    @Nonnull
    private String faultString;
    @Nullable
    private String faultActor;
    @Nullable
    private String wsAddressingActionURI;

    public SOAP11FaultContextDecoratingErrorHandler(@Nonnull Class<? extends Throwable> throwable, @Nonnull QName code, @Nonnull String message) {
        this(throwable, code, message, null, null);
    }

    public SOAP11FaultContextDecoratingErrorHandler(@Nonnull Class<? extends Throwable> throwable, @Nonnull QName code, @Nonnull String message, @Nullable String actor, @Nullable String addressingActionURI) {
        this.handledThrowable = (Class)Constraint.isNotNull(throwable, (String)"Handled Throwable type cannot be null");
        this.faultCode = (QName)Constraint.isNotNull((Object)code, (String)"Fault code cannot be null");
        this.faultString = (String)Constraint.isNotNull((Object)StringSupport.trim((String)message), (String)"Fault string cannot be null or empty");
        this.faultActor = StringSupport.trimOrNull((String)actor);
        this.wsAddressingActionURI = StringSupport.trimOrNull((String)addressingActionURI);
    }

    public boolean handlesError(@Nonnull Throwable t) {
        return this.handledThrowable.isInstance(t);
    }

    public boolean handleError(@Nonnull Throwable t, @Nonnull MessageContext messageContext) {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)this.faultCode, (String)this.faultString, (String)this.faultActor, null, null);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (Fault)fault);
        if (this.wsAddressingActionURI != null) {
            ((WSAddressingContext)messageContext.ensureSubcontext(WSAddressingContext.class)).setFaultActionURI(this.wsAddressingActionURI);
        }
        return true;
    }
}

