/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder.http.impl;

import com.google.common.net.MediaType;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;

public class HTTPSOAP11Decoder
extends BaseHttpServletRequestXMLMessageDecoder {
    @Nonnull
    private static final Set<MediaType> SUPPORTED_MEDIA_TYPES = CollectionSupport.singleton((Object)MediaType.create((String)"text", (String)"xml"));
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Decoder.class);
    @NonnullAfterInit
    private MessageHandler bodyHandler;

    public HTTPSOAP11Decoder() {
        this.setProtocolMessageLoggerSubCategory("SOAP");
    }

    @NonnullAfterInit
    public MessageHandler getBodyHandler() {
        return this.bodyHandler;
    }

    public void setBodyHandler(@Nonnull MessageHandler newBodyHandler) {
        this.bodyHandler = (MessageHandler)Constraint.isNotNull((Object)newBodyHandler, (String)"Body MessageHandler cannot be null");
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            throw new MessageDecodingException("HttpServletRequest was null");
        }
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        this.log.debug("Unmarshalling SOAP message");
        try (ServletInputStream in = request.getInputStream();){
            assert (in != null);
            Envelope soapMessage = (Envelope)this.unmarshallMessage((InputStream)in);
            ((SOAP11Context)messageContext.ensureSubcontext(SOAP11Context.class)).setEnvelope(soapMessage);
        }
        catch (IOException e) {
            this.log.error("Unable to obtain input stream from HttpServletRequest: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Unable to obtain input stream from HttpServletRequest", (Exception)e);
        }
        try {
            this.getBodyHandler().invoke(messageContext);
        }
        catch (MessageHandlerException e) {
            this.log.error("Error processing SOAP Envelope body: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Error processing SOAP Envelope body", (Exception)((Object)e));
        }
        if (messageContext.getMessage() == null) {
            this.log.warn("Body handler did not properly populate the message in message context");
            throw new MessageDecodingException("Body handler did not properly populate the message in message context");
        }
        this.setMessageContext(messageContext);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getBodyHandler() == null) {
            throw new ComponentInitializationException("Body handler MessageHandler cannot be null");
        }
    }

    @Nullable
    protected XMLObject getMessageToLog() {
        MessageContext mc = this.getMessageContext();
        return mc != null ? ((SOAP11Context)mc.ensureSubcontext(SOAP11Context.class)).getEnvelope() : null;
    }

    protected void validateHttpRequest(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        super.validateHttpRequest(request);
        if (!HttpServletSupport.validateContentType((HttpServletRequest)request, SUPPORTED_MEDIA_TYPES, (boolean)false, (boolean)false)) {
            this.log.warn("Saw unsupported request Content-Type: {}", (Object)request.getContentType());
            throw new MessageDecodingException(String.format("Content-Type '%s' was not a supported media type", request.getContentType()));
        }
    }
}

