/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.support.pac4j.authentication.DelegatedAuthenticationClientLogoutRequest;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationClientLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationClientLogoutAction.class);
    protected final DelegatedIdentityProviders identityProviders;
    protected final SessionStore sessionStore;
    protected final TicketRegistry ticketRegistry;

    protected Event doPreExecute(RequestContext requestContext) {
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext));
        UserProfile currentProfile = this.findCurrentProfile(context);
        Optional<Client> clientResult = this.findCurrentClient(currentProfile);
        if (clientResult.isPresent()) {
            Client client = clientResult.get();
            LOGGER.debug("Handling logout for delegated authentication client [{}]", (Object)client);
            DelegationWebflowUtils.putDelegatedAuthenticationClientName((RequestContext)requestContext, (String)client.getName());
        }
        return null;
    }

    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext));
        UserProfile currentProfile = this.findCurrentProfile(context);
        Optional<Client> clientResult = this.findCurrentClient(currentProfile);
        if (clientResult.isPresent()) {
            Client client = clientResult.get();
            LOGGER.trace("Located client [{}]", (Object)client);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            String targetUrl = Optional.ofNullable(service).map(Service::getId).orElse(null);
            LOGGER.debug("Logout target url based on service [{}] is [{}]", (Object)service, (Object)targetUrl);
            CallContext callContext = new CallContext((WebContext)context, this.sessionStore);
            Optional actionResult = client.getLogoutAction(callContext, currentProfile, targetUrl);
            actionResult.ifPresent(action -> {
                this.captureDelegatedAuthenticationLogoutRequest(requestContext, (RedirectionAction)action, targetUrl);
                LOGGER.debug("Adapting logout action [{}] for client [{}]", action, (Object)client);
                JEEHttpActionAdapter.INSTANCE.adapt((HttpAction)action, (WebContext)context);
            });
        } else {
            LOGGER.debug("The current client cannot be found; No logout action can execute");
        }
        return null;
    }

    protected DelegatedAuthenticationClientLogoutRequest captureDelegatedAuthenticationLogoutRequest(RequestContext requestContext, RedirectionAction action, String targetUrl) {
        DelegatedAuthenticationClientLogoutRequest.DelegatedAuthenticationClientLogoutRequestBuilder logoutActionBuilder = DelegatedAuthenticationClientLogoutRequest.builder().status(action.getCode()).message(action.getMessage()).target(targetUrl);
        if (action instanceof WithLocationAction) {
            WithLocationAction location = (WithLocationAction)action;
            logoutActionBuilder.location(location.getLocation());
        }
        DelegatedAuthenticationClientLogoutRequest logoutAction = logoutActionBuilder.build();
        DelegationWebflowUtils.putDelegatedAuthenticationLogoutRequest((RequestContext)requestContext, (Serializable)logoutAction);
        return logoutAction;
    }

    protected UserProfile findCurrentProfile(JEEContext webContext) {
        ProfileManager pm = new ProfileManager((WebContext)webContext, this.sessionStore);
        Optional profile = pm.getProfile();
        return profile.orElse(null);
    }

    protected Optional<Client> findCurrentClient(UserProfile currentProfile) {
        return currentProfile == null ? Optional.empty() : this.identityProviders.findClient(currentProfile.getClientName());
    }

    @Generated
    public DelegatedAuthenticationClientLogoutAction(DelegatedIdentityProviders identityProviders, SessionStore sessionStore, TicketRegistry ticketRegistry) {
        this.identityProviders = identityProviders;
        this.sessionStore = sessionStore;
        this.ticketRegistry = ticketRegistry;
    }
}

