/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata.keystore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;
import org.springframework.core.io.Resource;

public class SAML2FileSystemKeystoreGenerator
extends BaseSAML2KeystoreGenerator {
    private static final Pattern NORMALIZE_PATTERN = Pattern.compile("[^a-zA-Z0-9-_\\.]");

    public SAML2FileSystemKeystoreGenerator(SAML2Configuration configuration) {
        super(configuration);
    }

    private void writeEncodedCertificateToFile(File file, byte[] certificate) {
        if (file.exists()) {
            boolean res = file.delete();
            this.logger.debug("Deleted file [{}]:{}", (Object)file, (Object)res);
        }
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            PemObject pemObject = new PemObject(file.getName(), certificate);
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void writeBinaryCertificateToFile(File file, byte[] certificate) {
        if (file.exists()) {
            boolean res = file.delete();
            this.logger.debug("Deleted file [{}]:{}", (Object)file, (Object)res);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            ((OutputStream)fos).write(certificate);
            fos.flush();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean shouldGenerate() {
        this.validate();
        Resource keystoreFile = this.saml2Configuration.getKeystoreResource();
        return keystoreFile != null && !keystoreFile.exists() || super.shouldGenerate();
    }

    @Override
    public InputStream retrieve() throws Exception {
        this.validate();
        this.logger.debug("Retrieving keystore from {}", (Object)this.saml2Configuration.getKeystoreResource());
        return this.saml2Configuration.getKeystoreResource().getInputStream();
    }

    private void validate() {
        CommonHelper.assertNotNull((String)"keystoreResource", (Object)this.saml2Configuration.getKeystoreResource());
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.saml2Configuration.getKeystorePassword());
    }

    @Override
    protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) throws Exception {
        this.validate();
        File keystoreFile = this.saml2Configuration.getKeystoreResource().getFile();
        File parentFile = keystoreFile.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            this.logger.warn("Could not construct the directory structure for keystore: {}", (Object)keystoreFile.getCanonicalPath());
        }
        char[] password = this.saml2Configuration.getKeystorePassword().toCharArray();
        try (FileOutputStream fos = new FileOutputStream(keystoreFile.getCanonicalPath());){
            ks.store(fos, password);
            fos.flush();
        }
        File signingCertEncoded = this.getSigningBase64CertificatePath();
        this.writeEncodedCertificateToFile(signingCertEncoded, certificate.getEncoded());
        File signingCertBinary = this.getSigningBinaryCertificatePath();
        this.writeBinaryCertificateToFile(signingCertBinary, certificate.getEncoded());
        File signingKeyEncoded = this.getSigningKeyFile();
        this.writeEncodedCertificateToFile(signingKeyEncoded, privateKey.getEncoded());
    }

    private String getNormalizedCertificateName() {
        StringBuilder certName = new StringBuilder("saml-signing-cert");
        if (StringUtils.isNotBlank((CharSequence)this.saml2Configuration.getCertificateNameToAppend())) {
            certName.append('-');
            certName.append(NORMALIZE_PATTERN.matcher(this.saml2Configuration.getCertificateNameToAppend()).replaceAll(""));
        }
        return certName.toString();
    }

    private File getSigningBinaryCertificatePath() throws IOException {
        return new File(this.saml2Configuration.getKeystoreResource().getFile().getParentFile(), this.getNormalizedCertificateName() + ".crt");
    }

    private File getSigningBase64CertificatePath() throws IOException {
        return new File(this.saml2Configuration.getKeystoreResource().getFile().getParentFile(), this.getNormalizedCertificateName() + ".pem");
    }

    private File getSigningKeyFile() throws IOException {
        return new File(this.saml2Configuration.getKeystoreResource().getFile().getParentFile(), this.getNormalizedCertificateName() + ".key");
    }
}

