/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.common.engine.impl.ServiceConfigurator;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.event.EventDispatchAction;
import org.flowable.common.engine.impl.runtime.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceConfiguration<S> {
    protected final Logger logger = LoggerFactory.getLogger(AbstractServiceConfiguration.class);
    public static final String NO_TENANT_ID = "";
    protected String engineName;
    protected Collection<ServiceConfigurator<S>> configurators;
    protected boolean enableEventDispatcher = true;
    protected FlowableEventDispatcher eventDispatcher;
    protected List<FlowableEventListener> eventListeners;
    protected Map<String, List<FlowableEventListener>> typedEventListeners;
    protected List<EventDispatchAction> additionalEventDispatchActions;
    protected ObjectMapper objectMapper;
    protected Clock clock;
    protected IdGenerator idGenerator;

    public AbstractServiceConfiguration(String engineName) {
        this.engineName = engineName;
    }

    protected abstract S getService();

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public Collection<ServiceConfigurator<S>> getConfigurators() {
        return this.configurators;
    }

    public void setConfigurators(Collection<ServiceConfigurator<S>> configurators) {
        this.initConfigurators();
        this.configurators.clear();
        if (configurators != null) {
            this.configurators.addAll(configurators);
        }
    }

    public AbstractServiceConfiguration<S> addConfigurator(ServiceConfigurator<S> configurator) {
        this.initConfigurators();
        this.configurators.add(configurator);
        return this;
    }

    protected void initConfigurators() {
        if (this.configurators == null) {
            this.configurators = new ArrayList<ServiceConfigurator<S>>();
        }
    }

    protected void configuratorsBeforeInit() {
        if (this.configurators == null || this.configurators.isEmpty()) {
            return;
        }
        S service = this.getService();
        this.configurators.stream().sorted(Comparator.comparingInt(ServiceConfigurator::getPriority)).forEach(c -> {
            this.logger.info("Executing beforeInit() of {} (priority: {})", c.getClass(), (Object)c.getPriority());
            c.beforeInit(service);
        });
    }

    protected void configuratorsAfterInit() {
        if (this.configurators == null || this.configurators.isEmpty()) {
            return;
        }
        S service = this.getService();
        this.configurators.stream().sorted(Comparator.comparingInt(ServiceConfigurator::getPriority)).forEach(c -> {
            this.logger.info("Executing afterInit() of {} (priority: {})", c.getClass(), (Object)c.getPriority());
            c.afterInit(service);
        });
    }

    public boolean isEventDispatcherEnabled() {
        return this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled();
    }

    public boolean isEnableEventDispatcher() {
        return this.enableEventDispatcher;
    }

    public AbstractServiceConfiguration<S> setEnableEventDispatcher(boolean enableEventDispatcher) {
        this.enableEventDispatcher = enableEventDispatcher;
        return this;
    }

    public FlowableEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public AbstractServiceConfiguration<S> setEventDispatcher(FlowableEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        return this;
    }

    public List<FlowableEventListener> getEventListeners() {
        return this.eventListeners;
    }

    public AbstractServiceConfiguration<S> setEventListeners(List<FlowableEventListener> eventListeners) {
        this.eventListeners = eventListeners;
        return this;
    }

    public Map<String, List<FlowableEventListener>> getTypedEventListeners() {
        return this.typedEventListeners;
    }

    public AbstractServiceConfiguration<S> setTypedEventListeners(Map<String, List<FlowableEventListener>> typedEventListeners) {
        this.typedEventListeners = typedEventListeners;
        return this;
    }

    public List<EventDispatchAction> getAdditionalEventDispatchActions() {
        return this.additionalEventDispatchActions;
    }

    public AbstractServiceConfiguration<S> setAdditionalEventDispatchActions(List<EventDispatchAction> additionalEventDispatchActions) {
        this.additionalEventDispatchActions = additionalEventDispatchActions;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public AbstractServiceConfiguration<S> setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public AbstractServiceConfiguration<S> setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public AbstractServiceConfiguration<S> setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }
}

