/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullResultHandler;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultGroupPullResultHandler
extends AbstractPullResultHandler
implements GroupPullResultHandler {
    @Autowired
    private GroupProvisioningManager groupProvisioningManager;
    private final Map<String, String> groupOwnerMap = new HashMap<String, String>();

    public Map<String, String> getGroupOwnerMap() {
        return this.groupOwnerMap;
    }

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((GroupTO)GroupTO.class.cast(anyTO)).getName();
    }

    @Override
    protected String getName(AnyCR anyCR) {
        return ((GroupCR)GroupCR.class.cast(anyCR)).getName();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.groupProvisioningManager;
    }

    @Override
    protected AnyTO getAnyTO(Any any) {
        return this.groupDataBinder.getGroupTO((Group)any, true);
    }

    @Override
    protected WorkflowResult<? extends AnyUR> update(AnyUR req) {
        return this.gwfAdapter.update((GroupUR)req, this.profile.getExecutor(), this.profile.getContext());
    }

    @Override
    protected AnyTO doCreate(AnyCR anyCR, SyncDelta delta) {
        GroupCR groupCR = (GroupCR)GroupCR.class.cast(anyCR);
        ProvisioningManager.ProvisioningResult created = this.groupProvisioningManager.create(groupCR, this.groupOwnerMap, Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.profile.getContext());
        return this.groupDataBinder.getGroupTO((String)created.key());
    }

    @Override
    protected AnyUR doUpdate(AnyTO before, AnyUR req, SyncDelta delta, ProvisioningReport result) {
        GroupUR groupUR = (GroupUR)GroupUR.class.cast(req);
        ProvisioningManager.ProvisioningResult updated = this.groupProvisioningManager.update((AnyUR)groupUR, Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.profile.getContext());
        this.createRemediationIfNeeded(req, delta, result);
        String groupOwner = null;
        for (AttrPatch attrPatch : groupUR.getPlainAttrs()) {
            if (attrPatch.getOperation() != PatchOperation.ADD_REPLACE || attrPatch.getAttr() == null || !attrPatch.getAttr().getSchema().isEmpty() || attrPatch.getAttr().getValues().isEmpty()) continue;
            groupOwner = (String)attrPatch.getAttr().getValues().getFirst();
        }
        if (groupOwner != null) {
            this.groupOwnerMap.put(((GroupUR)updated.key()).getKey(), groupOwner);
        }
        return req;
    }
}

