/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.lang.management.ManagementFactory;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.springframework.context.ApplicationEventPublisher;

public class SystemLoadReporterJob
extends Job {
    protected static final Integer MB = 0x100000;
    protected final ApplicationEventPublisher publisher;

    public SystemLoadReporterJob(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    protected void execute(JobExecutionContext context) {
        SystemInfo.LoadInstant instant = new SystemInfo.LoadInstant();
        instant.setSystemLoadAverage(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        instant.setUptime(ManagementFactory.getRuntimeMXBean().getUptime());
        Runtime runtime = Runtime.getRuntime();
        instant.setTotalMemory(runtime.totalMemory() / (long)MB.intValue());
        instant.setMaxMemory(runtime.maxMemory() / (long)MB.intValue());
        instant.setFreeMemory(runtime.freeMemory() / (long)MB.intValue());
        this.publisher.publishEvent((Object)instant);
    }
}

