/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.provisioning.java.data.AttributableDataBinder;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;

public class RealmDataBinderImpl
extends AttributableDataBinder
implements RealmDataBinder {
    protected final AnyTypeDAO anyTypeDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final ImplementationDAO implementationDAO;
    protected final RealmDAO realmDAO;
    protected final PolicyDAO policyDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;
    protected final TemplateUtils templateUtils;

    public RealmDataBinderImpl(AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, ImplementationDAO implementationDAO, RealmDAO realmDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, DerAttrHandler derAttrHandler, PlainAttrValidationManager validator, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, JexlTools jexlTools, TemplateUtils templateUtils) {
        super(plainSchemaDAO, validator, derAttrHandler, mappingManager, intAttrNameParser, jexlTools);
        this.anyTypeDAO = anyTypeDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.implementationDAO = implementationDAO;
        this.realmDAO = realmDAO;
        this.policyDAO = policyDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
        this.templateUtils = templateUtils;
    }

    protected void fill(RealmTO realmTO, Realm realm, SyncopeClientCompositeException scce) {
        realm.getPlainAttrs().forEach(arg_0 -> ((Realm)realm).remove(arg_0));
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        realmTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = realm.getPlainAttr(schema.getKey()).orElseGet(() -> {
                PlainAttr newAttr = new PlainAttr();
                newAttr.setPlainSchema(schema);
                return newAttr;
            });
            this.fillAttr((AttributableTO)realmTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                realm.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        realm.getAnyTypeClass().getPlainSchemas().forEach(schema -> this.checkMandatory((PlainSchema)schema, realm.getPlainAttr(schema.getKey()).orElse(null), (Attributable)realm, reqValMissing));
        if (!reqValMissing.isEmpty()) {
            scce.addException(reqValMissing);
        }
    }

    protected void bind(Realm realm, RealmTO realmTO, SyncopeClientCompositeException scce) {
        realm.setName(realmTO.getName());
        if (realmTO.getAnyTypeClass() == null) {
            realm.setAnyTypeClass(null);
        } else {
            this.anyTypeClassDAO.findById(realmTO.getAnyTypeClass()).ifPresentOrElse(arg_0 -> ((Realm)realm).setAnyTypeClass(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), (Object)realmTO.getAnyTypeClass()));
        }
        if (realm.getAnyTypeClass() != null) {
            this.fill(realmTO, realm, scce);
        }
        realm.setAccessPolicy((AccessPolicy)Optional.ofNullable(realmTO.getAccessPolicy()).flatMap(p -> this.policyDAO.findById(p, AccessPolicy.class)).orElse(null));
        realm.setAccountPolicy((AccountPolicy)Optional.ofNullable(realmTO.getAccountPolicy()).flatMap(p -> this.policyDAO.findById(p, AccountPolicy.class)).orElse(null));
        realm.setAttrReleasePolicy((AttrReleasePolicy)Optional.ofNullable(realmTO.getAttrReleasePolicy()).flatMap(p -> this.policyDAO.findById(p, AttrReleasePolicy.class)).orElse(null));
        realm.setAuthPolicy((AuthPolicy)Optional.ofNullable(realmTO.getAuthPolicy()).flatMap(p -> this.policyDAO.findById(p, AuthPolicy.class)).orElse(null));
        realm.setPasswordPolicy((PasswordPolicy)Optional.ofNullable(realmTO.getPasswordPolicy()).flatMap(p -> this.policyDAO.findById(p, PasswordPolicy.class)).orElse(null));
        realm.setTicketExpirationPolicy((TicketExpirationPolicy)Optional.ofNullable(realmTO.getTicketExpirationPolicy()).flatMap(p -> this.policyDAO.findById(p, TicketExpirationPolicy.class)).orElse(null));
        realmTO.getActions().forEach(key -> this.implementationDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), key)));
        realm.getActions().removeIf(implementation -> !realmTO.getActions().contains(implementation.getKey()));
        this.templateUtils.check(realmTO.getTemplates(), ClientExceptionType.InvalidRealm);
        realmTO.getTemplates().forEach((key, template) -> this.anyTypeDAO.findById(key).ifPresentOrElse(type -> {
            AnyTemplateRealm anyTemplate = realm.getTemplate(type).orElse(null);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplateRealm)this.entityFactory.newEntity(AnyTemplateRealm.class);
                anyTemplate.setAnyType(type);
                anyTemplate.setRealm(realm);
                realm.add(anyTemplate);
            }
            anyTemplate.set(template);
        }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", key)));
        realm.getTemplates().removeIf(template -> !realmTO.getTemplates().containsKey(template.getAnyType().getKey()));
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    protected List<String> evaluateMandatoryCondition(ExternalResource resource, Realm realm) {
        if (resource.getOrgUnit() == null) {
            return List.of();
        }
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        MappingUtils.getPropagationItems(resource.getOrgUnit().getItems().stream()).forEach(item -> {
            AttrSchemaType schemaType;
            MappingManager.IntValues intValues;
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(item.getIntAttrName());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}', ignoring", (Object)item.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getSchema() != null && (intValues = this.mappingManager.getIntValues(resource, item, intAttrName, schemaType = intAttrName.getSchema() instanceof PlainSchema ? intAttrName.getSchema().getType() : AttrSchemaType.String, realm)).values().isEmpty() && this.jexlTools.evaluateMandatoryCondition(item.getMandatoryCondition(), (Attributable)realm, this.derAttrHandler)) {
                missingAttrNames.add(item.getIntAttrName());
            }
        });
        return missingAttrNames;
    }

    protected SyncopeClientException checkMandatoryOnResources(Realm realm) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        realm.getResources().stream().filter(ExternalResource::isEnforceMandatoryCondition).forEach(resource -> {
            List<String> missingAttrNames = this.evaluateMandatoryCondition((ExternalResource)resource, realm);
            if (!missingAttrNames.isEmpty()) {
                LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
                reqValMissing.getElements().addAll(missingAttrNames);
            }
        });
        return reqValMissing;
    }

    public Realm create(Realm parent, RealmTO realmTO) {
        Realm realm = (Realm)this.entityFactory.newEntity(Realm.class);
        realm.setParent(parent);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.bind(realm, realmTO, scce);
        realmTO.getResources().forEach(key -> this.resourceDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), key)));
        SyncopeClientException requiredValuesMissing = this.checkMandatoryOnResources(realm);
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        return realm;
    }

    public PropagationByResource<String> update(Realm realm, RealmTO realmTO) {
        realm.setParent((Realm)Optional.ofNullable(realmTO.getParent()).flatMap(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).orElse(null));
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.bind(realm, realmTO, scce);
        PropagationByResource propByRes = new PropagationByResource();
        realmTO.getResources().forEach(key -> this.resourceDAO.findById(key).ifPresentOrElse(resource -> {
            realm.add(resource);
            propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource.getKey()));
        }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), key)));
        realm.getResources().removeIf(resource -> {
            boolean contained = realmTO.getResources().contains(resource.getKey());
            if (!contained) {
                propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            }
            return !contained;
        });
        SyncopeClientException requiredValuesMissing = this.checkMandatoryOnResources(realm);
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        return propByRes;
    }

    public RealmTO getRealmTO(Realm realm, boolean admin) {
        RealmTO realmTO = new RealmTO();
        realmTO.setKey(realm.getKey());
        realmTO.setName(realm.getName());
        Optional.ofNullable(realm.getParent()).ifPresent(parent -> realmTO.setParent(parent.getKey()));
        realmTO.setFullPath(realm.getFullPath());
        Optional.ofNullable(realm.getAnyTypeClass()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAnyTypeClass(arg_0));
        realm.getPlainAttrs().forEach(plainAttr -> realmTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        this.derAttrHandler.getValues(realm).forEach((schema, value) -> realmTO.getDerAttrs().add(new Attr.Builder(schema.getKey()).value(value).build()));
        if (admin) {
            Optional.ofNullable(realm.getAccountPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAccountPolicy(arg_0));
            Optional.ofNullable(realm.getPasswordPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setPasswordPolicy(arg_0));
            Optional.ofNullable(realm.getAuthPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAuthPolicy(arg_0));
            Optional.ofNullable(realm.getAccessPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAccessPolicy(arg_0));
            Optional.ofNullable(realm.getAttrReleasePolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setAttrReleasePolicy(arg_0));
            Optional.ofNullable(realm.getTicketExpirationPolicy()).map(Entity::getKey).ifPresent(arg_0 -> ((RealmTO)realmTO).setTicketExpirationPolicy(arg_0));
            realmTO.getActions().addAll(realm.getActions().stream().map(Entity::getKey).toList());
            realm.getTemplates().forEach(template -> realmTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
            realmTO.getResources().addAll(realm.getResources().stream().map(Entity::getKey).toList());
        }
        return realmTO;
    }
}

