/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.Metadata;
import org.apache.syncope.ext.openfga.client.model.Userset;

@JsonPropertyOrder(value={"type", "relations", "metadata"})
public class TypeDefinition {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private String type;
    public static final String JSON_PROPERTY_RELATIONS = "relations";
    @Nullable
    private Map<String, Userset> relations = new HashMap<String, Userset>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Metadata metadata;

    public TypeDefinition type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public TypeDefinition relations(@Nullable Map<String, Userset> relations) {
        this.relations = relations;
        return this;
    }

    public TypeDefinition putRelationsItem(String key, Userset relationsItem) {
        if (this.relations == null) {
            this.relations = new HashMap<String, Userset>();
        }
        this.relations.put(key, relationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relations", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Userset> getRelations() {
        return this.relations;
    }

    @JsonProperty(value="relations", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelations(@Nullable Map<String, Userset> relations) {
        this.relations = relations;
    }

    public TypeDefinition metadata(@Nullable Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDefinition typeDefinition = (TypeDefinition)o;
        return Objects.equals(this.type, typeDefinition.type) && Objects.equals(this.relations, typeDefinition.relations) && Objects.equals(this.metadata, typeDefinition.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relations, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TypeDefinition {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    relations: ").append(this.toIndentedString(this.relations)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format(Locale.ROOT, "%stype%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getType()))));
        }
        if (this.getRelations() != null) {
            for (String _key : this.getRelations().keySet()) {
                if (this.getRelations().get(_key) == null) continue;
                joiner.add(this.getRelations().get(_key).toUrlQueryString(String.format(Locale.ROOT, "%srelations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        return joiner.toString();
    }
}

