/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;

final class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, @Nullable String sourceQuery, QueryRewriter queryRewriter, ValueExpressionDelegate valueExpressionDelegate) {
        this(method, em, method.getRequiredAnnotatedQuery(), sourceQuery, queryRewriter, valueExpressionDelegate);
    }

    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String sourceQuery, @Nullable String countQueryString, QueryRewriter queryRewriter, ValueExpressionDelegate valueExpressionDelegate) {
        super(method, em, sourceQuery, countQueryString, queryRewriter, valueExpressionDelegate);
        this.validateQuery(this.getQuery(), "Query '%s' validation failed for method %s", method);
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery(), "Count query '%s' validation failed for method %s", method);
        }
    }

    private void validateQuery(DeclaredQuery query, String errorMessage, JpaQueryMethod method) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        String queryString = query.getQueryString();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (EntityManager validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();){
                validatingEm.createQuery(queryString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(errorMessage.formatted(new Object[]{queryString, method}), e);
        }
    }
}

