/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity;

import java.util.List;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchPartQuery;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchPartQueryImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManager;
import org.flowable.batch.service.impl.persistence.entity.data.BatchPartDataManager;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractServiceEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class BatchPartEntityManagerImpl
extends AbstractServiceEngineEntityManager<BatchServiceConfiguration, BatchPartEntity, BatchPartDataManager>
implements BatchPartEntityManager {
    public BatchPartEntityManagerImpl(BatchServiceConfiguration batchServiceConfiguration, BatchPartDataManager batchPartDataManager) {
        super((AbstractServiceConfiguration)batchServiceConfiguration, batchServiceConfiguration.getEngineName(), (DataManager)batchPartDataManager);
    }

    @Override
    public List<BatchPart> findBatchPartsByBatchId(String batchId) {
        return ((BatchPartDataManager)this.dataManager).findBatchPartsByBatchId(batchId);
    }

    @Override
    public List<BatchPart> findBatchPartsByBatchIdAndStatus(String batchId, String status) {
        return ((BatchPartDataManager)this.dataManager).findBatchPartsByBatchIdAndStatus(batchId, status);
    }

    @Override
    public List<BatchPart> findBatchPartsByScopeIdAndType(String scopeId, String scopeType) {
        return ((BatchPartDataManager)this.dataManager).findBatchPartsByScopeIdAndType(scopeId, scopeType);
    }

    @Override
    public List<BatchPart> findBatchPartsByQueryCriteria(BatchPartQuery batchPartQuery) {
        return ((BatchPartDataManager)this.dataManager).findBatchPartsByQueryCriteria((BatchPartQueryImpl)batchPartQuery);
    }

    @Override
    public long findBatchPartCountByQueryCriteria(BatchPartQuery batchPartQuery) {
        return ((BatchPartDataManager)this.dataManager).findBatchPartCountByQueryCriteria((BatchPartQueryImpl)batchPartQuery);
    }

    @Override
    public BatchPartEntity createBatchPart(BatchEntity parentBatch, String status, String scopeId, String subScopeId, String scopeType) {
        BatchPartEntity batchPartEntity = (BatchPartEntity)((BatchPartDataManager)this.dataManager).create();
        batchPartEntity.setBatchId(parentBatch.getId());
        batchPartEntity.setType(parentBatch.getBatchType());
        batchPartEntity.setBatchType(parentBatch.getBatchType());
        batchPartEntity.setScopeId(scopeId);
        batchPartEntity.setSubScopeId(subScopeId);
        batchPartEntity.setScopeType(scopeType);
        batchPartEntity.setSearchKey(parentBatch.getBatchSearchKey());
        batchPartEntity.setSearchKey2(parentBatch.getBatchSearchKey2());
        batchPartEntity.setBatchSearchKey(parentBatch.getBatchSearchKey());
        batchPartEntity.setBatchSearchKey2(parentBatch.getBatchSearchKey2());
        batchPartEntity.setStatus(status);
        if (parentBatch.getTenantId() != null) {
            batchPartEntity.setTenantId(parentBatch.getTenantId());
        }
        batchPartEntity.setCreateTime(this.getClock().getCurrentTime());
        this.insert(batchPartEntity);
        return batchPartEntity;
    }

    @Override
    public BatchPartEntity completeBatchPart(String batchPartId, String status, String resultJson) {
        BatchPartEntity batchPartEntity = (BatchPartEntity)this.getBatchPartEntityManager().findById(batchPartId);
        batchPartEntity.setCompleteTime(this.getClock().getCurrentTime());
        batchPartEntity.setStatus(status);
        batchPartEntity.setResultDocumentJson(resultJson, ((BatchServiceConfiguration)this.serviceConfiguration).getEngineName());
        return batchPartEntity;
    }

    @Override
    public void deleteBatchPartEntityAndResources(BatchPartEntity batchPartEntity) {
        ByteArrayRef resultDocRefId = batchPartEntity.getResultDocRefId();
        if (resultDocRefId != null && resultDocRefId.getId() != null) {
            resultDocRefId.delete(((BatchServiceConfiguration)this.serviceConfiguration).getEngineName());
        }
        this.delete(batchPartEntity);
    }

    protected BatchPartEntityManager getBatchPartEntityManager() {
        return ((BatchServiceConfiguration)this.serviceConfiguration).getBatchPartEntityManager();
    }
}

