/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.bypass;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.BaseMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

public class GroovyMultifactorAuthenticationProviderBypassEvaluator
extends BaseMultifactorAuthenticationProviderBypassEvaluator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyMultifactorAuthenticationProviderBypassEvaluator.class);
    private static final long serialVersionUID = -4909072898415688377L;
    private final ExecutableCompiledScript watchableScript;

    public GroovyMultifactorAuthenticationProviderBypassEvaluator(MultifactorAuthenticationProviderBypassProperties bypassProperties, String providerId, ConfigurableApplicationContext applicationContext) {
        super(providerId, (ApplicationContext)applicationContext);
        Resource groovyScript = bypassProperties.getGroovy().getLocation();
        Optional scriptFactory = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
        this.watchableScript = scriptFactory.map(factory -> factory.fromResource(groovyScript)).orElse(null);
    }

    @Override
    public boolean shouldMultifactorAuthenticationProviderExecuteInternal(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        return this.watchableScript != null && (Boolean)FunctionUtils.doAndHandle(() -> {
            Principal principal = this.resolvePrincipal(authentication.getPrincipal());
            LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}] via Groovy script [{}]", new Object[]{principal.getId(), registeredService, provider, this.watchableScript});
            Object[] args = new Object[]{authentication, principal, registeredService, provider, LOGGER, request};
            return (Boolean)this.watchableScript.execute(args, Boolean.class);
        }, e -> true).get() != false;
    }
}

