/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchPayloadGenerator;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.ExecQuery;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.common.rest.api.service.ExecutableService;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.data.domain.Page;

public abstract class AbstractExecutableService
extends AbstractService
implements ExecutableService {
    protected abstract AbstractExecutableLogic<?> getExecutableLogic();

    public PagedResult<ExecTO> listExecutions(ExecQuery query) {
        Page result = this.getExecutableLogic().listExecutions(query.getKey(), query.getBefore(), query.getAfter(), AbstractExecutableService.pageable((AbstractQuery)query));
        return this.buildPagedResult(result);
    }

    public List<ExecTO> listRecentExecutions(int max) {
        return this.getExecutableLogic().listRecentExecutions(max);
    }

    public void deleteExecution(String executionKey) {
        this.getExecutableLogic().deleteExecution(executionKey);
    }

    public Response deleteExecutions(ExecQuery query) {
        List batchResponseItems = this.getExecutableLogic().deleteExecutions(query.getKey(), query.getBefore(), query.getAfter());
        String boundary = "deleteExecutions_" + SecureRandomUtils.generateRandomUUID().toString();
        return Response.ok((Object)BatchPayloadGenerator.generate((List)batchResponseItems, (String)("--" + boundary))).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
    }

    public ExecTO execute(ExecSpecs execSpecs) {
        return this.getExecutableLogic().execute(execSpecs);
    }

    public JobTO getJob(String key) {
        return this.getExecutableLogic().getJob(key);
    }

    public List<JobTO> listJobs() {
        return this.getExecutableLogic().listJobs();
    }

    public void actionJob(String key, JobAction action) {
        this.getExecutableLogic().actionJob(key, action);
    }
}

