/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import jakarta.ws.rs.NotAuthorizedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.DomainDropDown;
import org.apache.syncope.client.ui.commons.StyledNotificationBehavior;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.syncope.client.ui.commons.panels.NotificationPanel;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLogin
extends WebPage {
    private static final long serialVersionUID = 5889157642852559004L;
    protected static final Logger LOG = LoggerFactory.getLogger(BaseLogin.class);
    @SpringBean
    protected DomainOps domainOps;
    protected final NotificationPanel notificationPanel;
    protected final StatelessForm<Void> form;
    protected final TextField<String> usernameField;
    protected final TextField<String> passwordField;
    protected final LocaleDropDown languageSelect;
    protected final DomainDropDown domainSelect;
    protected String notificationMessage;
    protected String notificationLevel;
    protected final LoadableDetachableModel<List<String>> domains = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<String> load() {
            ArrayList<String> current = new ArrayList<String>();
            current.addAll(BaseLogin.this.domainOps.list().stream().map(Domain::getKey).sorted().toList());
            current.addFirst("Master");
            return current;
        }
    };

    public BaseLogin(PageParameters parameters) {
        super(parameters);
        this.setStatelessHint(true);
        this.notificationPanel = new NotificationPanel("feedback");
        this.add(new Component[]{this.notificationPanel});
        if (!parameters.get("notificationMessage").isNull()) {
            this.notificationMessage = parameters.get("notificationMessage").toString();
            this.notificationLevel = parameters.get("notificationLevel").isEmpty() ? "success" : parameters.get("notificationLevel").toString();
        }
        this.form = new StatelessForm("login");
        this.usernameField = new TextField("username", (IModel)new Model());
        this.usernameField.setMarkupId("username");
        this.form.add(new Component[]{this.usernameField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown("language");
        this.languageSelect.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                BaseLogin.this.getLanguageOnChangeComponents().forEach(xva$0 -> target.add(new Component[]{xva$0}));
            }
        }}).add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                BaseLogin.this.getLanguageOnChangeComponents().forEach(xva$0 -> target.add(new Component[]{xva$0}));
            }
        }});
        this.form.add(new Component[]{this.languageSelect.setOutputMarkupId(true)});
        this.domainSelect = new DomainDropDown("domain", (IModel<List<String>>)this.domains);
        this.domainSelect.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                BaseLogin.this.getDomainOnChangeComponents().forEach(xva$0 -> target.add(new Component[]{xva$0}));
            }
        }}).add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                BaseLogin.this.getDomainOnChangeComponents().forEach(xva$0 -> target.add(new Component[]{xva$0}));
            }
        }});
        this.form.add(new Component[]{this.domainSelect.setOutputMarkupId(true)});
        AjaxButton submitButton = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 429178684321093953L;

            protected void onSubmit(AjaxRequestTarget target) {
                BaseLogin.this.authenticate(BaseLogin.this.usernameField.getValue(), BaseLogin.this.passwordField.getRawInput(), target);
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.form.setDefaultButton((IFormSubmittingComponent)submitButton);
        ListView<BaseSSOLoginFormPanel> ssoLogins = new ListView<BaseSSOLoginFormPanel>("ssoLogins", this.getSSOLoginFormPanels()){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<BaseSSOLoginFormPanel> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        };
        this.form.add(new Component[]{ssoLogins});
        this.add(new Component[]{this.form});
    }

    protected Collection<Component> getLanguageOnChangeComponents() {
        return List.of(this.form);
    }

    protected Collection<Component> getDomainOnChangeComponents() {
        return List.of(this.form);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (StringUtils.isNotBlank((CharSequence)this.notificationMessage)) {
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)StyledNotificationBehavior.jQueryShow(this.notificationMessage, String.format("jQuery('#%s').data('kendoNotification')", this.notificationPanel.getNotificationMarkupId()), this.notificationLevel)));
        }
    }

    protected abstract BaseSession getBaseSession();

    protected abstract List<BaseSSOLoginFormPanel> getSSOLoginFormPanels();

    protected abstract void sendError(String var1);

    protected abstract void authenticate(String var1, String var2, AjaxRequestTarget var3) throws NotAuthorizedException;

    protected class LocaleDropDown
    extends DropDownChoice<Locale> {
        private static final long serialVersionUID = 2349382679992357202L;

        protected LocaleDropDown(String id) {
            super(id, BaseLogin.this.getBaseSession().getSupportedLocales());
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel((IModel)new IModel<Locale>(){
                private static final long serialVersionUID = -6985170095629312963L;

                public Locale getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Locale object) {
                    LocaleDropDown.this.getSession().setLocale(object);
                }

                public void detach() {
                }
            });
            List<Object> filtered = List.of();
            String acceptLanguage = ((ServletWebRequest)RequestCycle.get().getRequest()).getHeader("Accept-Language");
            if (StringUtils.isNotBlank((CharSequence)acceptLanguage)) {
                try {
                    filtered = Locale.filter(Locale.LanguageRange.parse(acceptLanguage), BaseLogin.this.getBaseSession().getSupportedLocales());
                }
                catch (Exception e) {
                    LOG.debug("Could not parse {} HTTP header value '{}'", new Object[]{"Accept-Language", acceptLanguage, e});
                }
            }
            this.getModel().setObject((Object)(filtered.isEmpty() ? Locale.ENGLISH : (Locale)filtered.getFirst()));
        }

        protected class LocaleRenderer
        extends ChoiceRenderer<Locale> {
            private static final long serialVersionUID = -3657529581555164741L;

            protected LocaleRenderer() {
            }

            public String getDisplayValue(Locale locale) {
                return locale.getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

