/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProviderCreator;
import org.apache.kafka.common.security.ssl.mock.TestPlainSaslServerProviderCreator;
import org.apache.kafka.common.security.ssl.mock.TestScramSaslServerProviderCreator;
import org.apache.kafka.common.utils.SecurityUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SecurityUtilsTest {
    private final SecurityProviderCreator testScramSaslServerProviderCreator = new TestScramSaslServerProviderCreator();
    private final SecurityProviderCreator testPlainSaslServerProviderCreator = new TestPlainSaslServerProviderCreator();
    private final Provider testScramSaslServerProvider = this.testScramSaslServerProviderCreator.getProvider();
    private final Provider testPlainSaslServerProvider = this.testPlainSaslServerProviderCreator.getProvider();

    private void clearTestProviders() {
        Security.removeProvider(this.testScramSaslServerProvider.getName());
        Security.removeProvider(this.testPlainSaslServerProvider.getName());
    }

    @BeforeEach
    public void setUp() {
        this.clearTestProviders();
    }

    @AfterEach
    public void tearDown() {
        this.clearTestProviders();
    }

    @Test
    public void testPrincipalNameCanContainSeparator() {
        String name = "name:with:separator:in:it";
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)("User:" + name));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)name, (Object)principal.getName());
    }

    @Test
    public void testParseKafkaPrincipalWithNonUserPrincipalType() {
        String name = "foo";
        String principalType = "Group";
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)(principalType + ":" + name));
        Assertions.assertEquals((Object)principalType, (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)name, (Object)principal.getName());
    }

    private int getProviderIndexFromName(String providerName, Provider[] providers) {
        for (int index = 0; index < providers.length; ++index) {
            if (!providers[index].getName().equals(providerName)) continue;
            return index;
        }
        return -1;
    }

    @Test
    public void testAddCustomSecurityProvider() {
        String customProviderClasses = this.testScramSaslServerProviderCreator.getClass().getName() + "," + this.testPlainSaslServerProviderCreator.getClass().getName();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("security.providers", customProviderClasses);
        SecurityUtils.addConfiguredSecurityProviders(configs);
        Provider[] providers = Security.getProviders();
        int testScramSaslServerProviderIndex = this.getProviderIndexFromName(this.testScramSaslServerProvider.getName(), providers);
        int testPlainSaslServerProviderIndex = this.getProviderIndexFromName(this.testPlainSaslServerProvider.getName(), providers);
        Assertions.assertEquals((int)0, (int)testScramSaslServerProviderIndex, (String)(this.testScramSaslServerProvider.getName() + " testProvider not found at expected index"));
        Assertions.assertEquals((int)1, (int)testPlainSaslServerProviderIndex, (String)(this.testPlainSaslServerProvider.getName() + " testProvider not found at expected index"));
    }
}

