/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.utils.CircularIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircularIteratorTest {
    @Test
    public void testNullCollection() {
        Assertions.assertThrows(NullPointerException.class, () -> new CircularIterator(null));
    }

    @Test
    public void testEmptyCollection() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CircularIterator(Collections.emptyList()));
    }

    @Test
    public void testCycleCollection() {
        CircularIterator it = new CircularIterator(Arrays.asList("A", "B", null, "C"));
        Assertions.assertEquals((Object)"A", (Object)it.peek());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"A", (Object)it.next());
        Assertions.assertEquals((Object)"B", (Object)it.peek());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"B", (Object)it.next());
        Assertions.assertNull((Object)it.peek());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertNull((Object)it.next());
        Assertions.assertEquals((Object)"C", (Object)it.peek());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"C", (Object)it.next());
        Assertions.assertEquals((Object)"A", (Object)it.peek());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"A", (Object)it.next());
        Assertions.assertEquals((Object)"B", (Object)it.peek());
        Assertions.assertEquals((Object)"B", (Object)it.peek());
    }
}

