/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationResult;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationUtils;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerValidationUtilsTest {
    private static final String QUOTE = "\"";
    private static final String HEADER_COMPACT_SERIALIZATION = Base64.getUrlEncoder().withoutPadding().encodeToString("{\"alg\":\"none\"}".getBytes(StandardCharsets.UTF_8)) + ".";
    private static final Time TIME = Time.SYSTEM;

    @Test
    public void validateClaimForExistenceAndType() throws OAuthBearerIllegalTokenException {
        String claimName = "foo";
        for (Boolean exists : new Boolean[]{null, Boolean.TRUE, Boolean.FALSE}) {
            boolean useErrorValue = exists == null;
            boolean[] blArray = new boolean[]{true, false};
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean required = blArray[i];
                StringBuilder sb = new StringBuilder("{");
                OAuthBearerValidationUtilsTest.appendJsonText(sb, "exp", 100);
                OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "sub", "principalName");
                if (useErrorValue) {
                    OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, claimName, 1);
                } else if (exists.booleanValue()) {
                    OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, claimName, claimName);
                }
                sb.append("}");
                String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
                OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
                OAuthBearerValidationResult result = OAuthBearerValidationUtils.validateClaimForExistenceAndType((OAuthBearerUnsecuredJws)testJwt, (boolean)required, (String)claimName, (Class[])new Class[]{String.class});
                if (useErrorValue || required.booleanValue() && !exists.booleanValue()) {
                    Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isFailureWithMessageAndNoFailureScope(result));
                    continue;
                }
                Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result));
            }
        }
    }

    @Test
    public void validateIssuedAt() {
        long nowMs = TIME.milliseconds();
        double nowClaimValue = (double)nowMs / 1000.0;
        for (boolean exists : new boolean[]{true, false}) {
            StringBuilder sb = new StringBuilder("{");
            OAuthBearerValidationUtilsTest.appendJsonText(sb, "exp", nowClaimValue);
            OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "sub", "principalName");
            if (exists) {
                OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "iat", nowClaimValue);
            }
            sb.append("}");
            String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
            OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
            for (boolean required : new boolean[]{true, false}) {
                for (int allowableClockSkewMs : new int[]{0, 5, 10, 20}) {
                    for (long whenCheckOffsetMs : new long[]{-10L, 0L, 10L}) {
                        long whenCheckMs = nowMs + whenCheckOffsetMs;
                        OAuthBearerValidationResult result = OAuthBearerValidationUtils.validateIssuedAt((OAuthBearerUnsecuredJws)testJwt, (boolean)required, (long)whenCheckMs, (int)allowableClockSkewMs);
                        if (required && !exists) {
                            Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isFailureWithMessageAndNoFailureScope(result), (String)"useErrorValue || required && !exists");
                            continue;
                        }
                        if (!required && !exists) {
                            Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result), (String)"!required && !exists");
                            continue;
                        }
                        if (nowClaimValue * 1000.0 > (double)(whenCheckMs + (long)allowableClockSkewMs)) {
                            Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isFailureWithMessageAndNoFailureScope(result), (String)OAuthBearerValidationUtilsTest.assertionFailureMessage(nowClaimValue, allowableClockSkewMs, whenCheckMs));
                            continue;
                        }
                        Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result), (String)OAuthBearerValidationUtilsTest.assertionFailureMessage(nowClaimValue, allowableClockSkewMs, whenCheckMs));
                    }
                }
            }
        }
    }

    @Test
    public void validateExpirationTime() {
        long nowMs = TIME.milliseconds();
        double nowClaimValue = (double)nowMs / 1000.0;
        StringBuilder sb = new StringBuilder("{");
        OAuthBearerValidationUtilsTest.appendJsonText(sb, "exp", nowClaimValue);
        OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "sub", "principalName");
        sb.append("}");
        String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
        OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
        for (int allowableClockSkewMs : new int[]{0, 5, 10, 20}) {
            for (long whenCheckOffsetMs : new long[]{-10L, 0L, 10L}) {
                long whenCheckMs = nowMs + whenCheckOffsetMs;
                OAuthBearerValidationResult result = OAuthBearerValidationUtils.validateExpirationTime((OAuthBearerUnsecuredJws)testJwt, (long)whenCheckMs, (int)allowableClockSkewMs);
                if ((double)(whenCheckMs - (long)allowableClockSkewMs) >= nowClaimValue * 1000.0) {
                    Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isFailureWithMessageAndNoFailureScope(result), (String)OAuthBearerValidationUtilsTest.assertionFailureMessage(nowClaimValue, allowableClockSkewMs, whenCheckMs));
                    continue;
                }
                Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result), (String)OAuthBearerValidationUtilsTest.assertionFailureMessage(nowClaimValue, allowableClockSkewMs, whenCheckMs));
            }
        }
    }

    @Test
    public void validateExpirationTimeAndIssuedAtConsistency() throws OAuthBearerIllegalTokenException {
        long nowMs = TIME.milliseconds();
        double nowClaimValue = (double)nowMs / 1000.0;
        for (boolean issuedAtExists : new boolean[]{true, false}) {
            if (!issuedAtExists) {
                StringBuilder sb = new StringBuilder("{");
                OAuthBearerValidationUtilsTest.appendJsonText(sb, "exp", nowClaimValue);
                OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "sub", "principalName");
                sb.append("}");
                String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
                OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
                Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(OAuthBearerValidationUtils.validateTimeConsistency((OAuthBearerUnsecuredJws)testJwt)));
                continue;
            }
            for (int expirationTimeOffset = -1; expirationTimeOffset <= 1; ++expirationTimeOffset) {
                StringBuilder sb = new StringBuilder("{");
                OAuthBearerValidationUtilsTest.appendJsonText(sb, "iat", nowClaimValue);
                OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "exp", nowClaimValue + (double)expirationTimeOffset);
                OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "sub", "principalName");
                sb.append("}");
                String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
                OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
                OAuthBearerValidationResult result = OAuthBearerValidationUtils.validateTimeConsistency((OAuthBearerUnsecuredJws)testJwt);
                if (expirationTimeOffset <= 0) {
                    Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isFailureWithMessageAndNoFailureScope(result));
                    continue;
                }
                Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result));
            }
        }
    }

    @Test
    public void validateScope() {
        long nowMs = TIME.milliseconds();
        double nowClaimValue = (double)nowMs / 1000.0;
        List noScope = Collections.emptyList();
        List<String> scope1 = Arrays.asList("scope1");
        List<String> scope1And2 = Arrays.asList("scope1", "scope2");
        for (boolean actualScopeExists : new boolean[]{true, false}) {
            List<List> scopes = !actualScopeExists ? Arrays.asList(new List[]{null}) : Arrays.asList(noScope, scope1, scope1And2);
            for (List actualScope : scopes) {
                for (boolean requiredScopeExists : new boolean[]{true, false}) {
                    List<List> requiredScopes = !requiredScopeExists ? Arrays.asList(new List[]{null}) : Arrays.asList(noScope, scope1, scope1And2);
                    for (List requiredScope : requiredScopes) {
                        StringBuilder sb = new StringBuilder("{");
                        OAuthBearerValidationUtilsTest.appendJsonText(sb, "exp", nowClaimValue);
                        OAuthBearerValidationUtilsTest.appendCommaJsonText(sb, "sub", "principalName");
                        if (actualScope != null) {
                            sb.append(',').append(OAuthBearerValidationUtilsTest.scopeJson(actualScope));
                        }
                        sb.append("}");
                        String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
                        OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
                        OAuthBearerValidationResult result = OAuthBearerValidationUtils.validateScope((OAuthBearerToken)testJwt, (List)requiredScope);
                        if (!requiredScopeExists || requiredScope.isEmpty()) {
                            Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result));
                            continue;
                        }
                        if (!actualScopeExists || actualScope.size() < requiredScope.size()) {
                            Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isFailureWithMessageAndFailureScope(result));
                            continue;
                        }
                        Assertions.assertTrue((boolean)OAuthBearerValidationUtilsTest.isSuccess(result));
                    }
                }
            }
        }
    }

    private static String assertionFailureMessage(double claimValue, int allowableClockSkewMs, long whenCheckMs) {
        return String.format("time=%f seconds, whenCheck = %d ms, allowableClockSkew=%d ms", claimValue, whenCheckMs, allowableClockSkewMs);
    }

    private static boolean isSuccess(OAuthBearerValidationResult result) {
        return result.success();
    }

    private static boolean isFailureWithMessageAndNoFailureScope(OAuthBearerValidationResult result) {
        return !result.success() && !result.failureDescription().isEmpty() && result.failureScope() == null && result.failureOpenIdConfig() == null;
    }

    private static boolean isFailureWithMessageAndFailureScope(OAuthBearerValidationResult result) {
        return !result.success() && !result.failureDescription().isEmpty() && !result.failureScope().isEmpty() && result.failureOpenIdConfig() == null;
    }

    private static void appendCommaJsonText(StringBuilder sb, String claimName, Number claimValue) {
        sb.append(',').append(QUOTE).append(OAuthBearerValidationUtilsTest.escape(claimName)).append(QUOTE).append(":").append(claimValue);
    }

    private static void appendCommaJsonText(StringBuilder sb, String claimName, String claimValue) {
        sb.append(',').append(QUOTE).append(OAuthBearerValidationUtilsTest.escape(claimName)).append(QUOTE).append(":").append(QUOTE).append(OAuthBearerValidationUtilsTest.escape(claimValue)).append(QUOTE);
    }

    private static void appendJsonText(StringBuilder sb, String claimName, Number claimValue) {
        sb.append(QUOTE).append(OAuthBearerValidationUtilsTest.escape(claimName)).append(QUOTE).append(":").append(claimValue);
    }

    private static String escape(String jsonStringValue) {
        return jsonStringValue.replace(QUOTE, "\\\"").replace("\\", "\\\\");
    }

    private static String scopeJson(List<String> scope) {
        StringBuilder scopeJsonBuilder = new StringBuilder("\"scope\":[");
        int initialLength = scopeJsonBuilder.length();
        for (String scopeValue : scope) {
            if (scopeJsonBuilder.length() > initialLength) {
                scopeJsonBuilder.append(',');
            }
            scopeJsonBuilder.append('\"').append(scopeValue).append('\"');
        }
        scopeJsonBuilder.append(']');
        return scopeJsonBuilder.toString();
    }
}

