/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import java.util.Optional;
import java.util.Set;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCreate;
import net.tirasa.connid.bundles.googleapps.GoogleAppsDelete;
import net.tirasa.connid.bundles.googleapps.GoogleAppsSearch;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUpdate;
import net.tirasa.connid.bundles.googleapps.GroupHandler;
import net.tirasa.connid.bundles.googleapps.LicenseAssignmentsHandler;
import net.tirasa.connid.bundles.googleapps.MembersHandler;
import net.tirasa.connid.bundles.googleapps.OrgunitsHandler;
import net.tirasa.connid.bundles.googleapps.UserHandler;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="GoogleApps.connector.display", configurationClass=GoogleAppsConfiguration.class)
public class GoogleAppsConnector
implements PoolableConnector,
TestOp,
SchemaOp,
SearchOp<Filter>,
CreateOp,
UpdateOp,
UpdateDeltaOp,
DeleteOp {
    private GoogleAppsConfiguration configuration;
    private Schema schema = null;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        this.configuration = (GoogleAppsConfiguration)configuration;
    }

    public void dispose() {
        Optional.ofNullable(this.configuration).ifPresent(GoogleAppsConfiguration::release);
        this.configuration = null;
    }

    public void test() {
        try {
            this.configuration.test();
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void checkAlive() {
        this.test();
    }

    public Schema schema() {
        if (null == this.schema) {
            SchemaBuilder builder = new SchemaBuilder(GoogleAppsConnector.class);
            ObjectClassInfo user = UserHandler.getObjectClassInfo(this.configuration.getCustomSchemasJSON());
            builder.defineObjectClass(user);
            ObjectClassInfo group = GroupHandler.getObjectClassInfo();
            builder.defineObjectClass(group);
            ObjectClassInfo member = MembersHandler.getObjectClassInfo();
            builder.defineObjectClass(member);
            ObjectClassInfo orgUnit = OrgunitsHandler.getObjectClassInfo();
            builder.defineObjectClass(orgUnit);
            ObjectClassInfo licenseAssignment = LicenseAssignmentsHandler.getObjectClassInfo();
            builder.defineObjectClass(licenseAssignment);
            builder.defineOperationOption(OperationOptionInfoBuilder.buildAttributesToGet(), new Class[]{SearchOp.class});
            builder.defineOperationOption(OperationOptionInfoBuilder.buildPageSize(), new Class[]{SearchOp.class});
            builder.defineOperationOption(OperationOptionInfoBuilder.buildPagedResultsCookie(), new Class[]{SearchOp.class});
            builder.defineOperationOption(OperationOptionInfoBuilder.buildSortKeys(), new Class[]{SearchOp.class});
            builder.defineOperationOption(new OperationOptionInfo("showDeleted", Boolean.class), new Class[]{SearchOp.class});
            this.schema = builder.build();
        }
        return this.schema;
    }

    public FilterTranslator<Filter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return xva$0 -> CollectionUtil.newList((Object[])new Filter[]{xva$0});
    }

    public void executeQuery(ObjectClass objectClass, Filter query, ResultsHandler handler, OperationOptions options) {
        new GoogleAppsSearch(this.configuration, objectClass, query, handler, options).execute();
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        return new GoogleAppsCreate(this.configuration, objectClass, createAttributes).execute();
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        return new GoogleAppsUpdate(this.configuration, objectClass, uid).update(replaceAttributes);
    }

    public Set<AttributeDelta> updateDelta(ObjectClass objectClass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        return new GoogleAppsUpdate(this.configuration, objectClass, uid).updateDelta(modifications);
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        new GoogleAppsDelete(this.configuration, objectClass, uid).execute();
    }
}

