/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects.filter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.filter.CompositeFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;

public final class OrFilter
extends CompositeFilter {
    private LinkedList<Filter> subFilters;

    public OrFilter(Filter left, Filter right) {
        this(CollectionUtil.newList(left, right));
    }

    public OrFilter(Collection<Filter> filters) {
        super(null, null);
        this.subFilters = new LinkedList<Filter>(filters);
    }

    @Override
    public boolean accept(ConnectorObject obj) {
        Filter subFilter;
        boolean result = false;
        Iterator iterator = this.subFilters.iterator();
        while (iterator.hasNext() && !(result = (subFilter = (Filter)iterator.next()).accept(obj))) {
        }
        return result;
    }

    @Override
    public <R, P> R accept(FilterVisitor<R, P> v, P p) {
        return v.visitOrFilter(p, this);
    }

    @Override
    public Filter getLeft() {
        return this.subFilters.getFirst();
    }

    @Override
    public Filter getRight() {
        if (this.subFilters.size() > 2) {
            LinkedList<Filter> right = new LinkedList<Filter>(this.subFilters);
            right.removeFirst();
            return new OrFilter(right);
        }
        if (this.subFilters.size() == 2) {
            return this.subFilters.getLast();
        }
        return null;
    }

    @Override
    public Collection<Filter> getFilters() {
        return CollectionUtil.asReadOnlyList(this.subFilters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append('(');
        boolean isFirst = true;
        for (Filter subFilter : this.subFilters) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" or ");
            }
            builder.append(subFilter);
        }
        return builder.append(')').toString();
    }
}

