/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.cloudwatch2;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.time.Duration;
import java.util.function.Function;

public interface CloudWatchConfig
extends StepRegistryConfig {
    public static final int MAX_BATCH_SIZE = 1000;

    default public String prefix() {
        return "cloudwatch";
    }

    default public String namespace() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"namespace").required().get();
    }

    default public int batchSize() {
        return Math.min((Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"batchSize").orElse((Object)1000), 1000);
    }

    @Incubating(since="1.6.0")
    default public boolean highResolution() {
        return this.step().compareTo(Duration.ofMinutes(1L)) < 0;
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"namespace", CloudWatchConfig::namespace), MeterRegistryConfigValidator.check((String)"batchSize", CloudWatchConfig::batchSize).andThen(v -> v.invalidateWhen(b -> b > 1000, "cannot be greater than 1000", InvalidReason.MALFORMED))});
    }
}

