/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;

@Embeddable
@Table(name="RegexRegisteredServiceProperty")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceProperty
implements RegisteredServiceProperty {
    public static final String TABLE_NAME = "RegexRegisteredServiceProperty";
    private static final long serialVersionUID = 1349556364689133211L;
    @Lob
    @Column(name="property_values")
    @ExpressionLanguageCapable
    private HashSet<String> values = new HashSet(0);

    public DefaultRegisteredServiceProperty(String ... propertyValues) {
        this.setValues(Arrays.stream(propertyValues).collect(Collectors.toSet()));
    }

    public DefaultRegisteredServiceProperty(Collection<String> propertyValues) {
        this.setValues(new HashSet<String>(propertyValues));
    }

    public Set<String> getValues() {
        if (this.values == null) {
            this.values = new HashSet(0);
        }
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        return this.values.stream().map(arg_0 -> ((SpringExpressionLanguageValueResolver)resolver).resolve(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void setValues(Set<String> values) {
        this.values.clear();
        if (values == null) {
            return;
        }
        this.values.addAll(values);
    }

    @JsonIgnore
    public String value() {
        if (this.values.isEmpty()) {
            return null;
        }
        return SpringExpressionLanguageValueResolver.getInstance().resolve(this.values.iterator().next());
    }

    public boolean contains(String value) {
        return this.getValues().contains(value);
    }

    @CanIgnoreReturnValue
    public RegisteredServiceProperty addValue(String value) {
        this.values.add(value);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceProperty)) {
            return false;
        }
        DefaultRegisteredServiceProperty other = (DefaultRegisteredServiceProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashSet<String> this$values = this.values;
        HashSet<String> other$values = other.values;
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashSet<String> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceProperty(values=" + String.valueOf(this.values) + ")";
    }

    @Generated
    public DefaultRegisteredServiceProperty() {
    }
}

