/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.AttributeValueCompleteness;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;

public class Attribute {
    private final String name;
    private final List<Object> value;
    private final AttributeValueCompleteness attributeValueCompleteness;

    Attribute(String name, List<Object> value) {
        this(name, value, AttributeValueCompleteness.COMPLETE);
    }

    Attribute(String name, List<Object> value, AttributeValueCompleteness attributeValueCompleteness) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("Name must not be blank!");
        }
        if (OperationalAttributes.PASSWORD_NAME.equals(name) || OperationalAttributes.CURRENT_PASSWORD_NAME.equals(name)) {
            if (value != null && value.size() > 1) {
                throw new IllegalArgumentException("Password attribute must be single-value.");
            }
            if (value != null && value.size() == 1 && !(value.get(0) instanceof GuardedString)) {
                throw new IllegalArgumentException("Password value must be an instance of GuardedString");
            }
        }
        this.name = name;
        this.value = value == null ? null : CollectionUtil.newReadOnlyList(value);
        this.attributeValueCompleteness = attributeValueCompleteness;
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getValue() {
        return this.value == null ? null : Collections.unmodifiableList(this.value);
    }

    public AttributeValueCompleteness getAttributeValueCompleteness() {
        return this.attributeValueCompleteness;
    }

    public boolean is(String name) {
        return NameUtil.namesEqual(this.name, name);
    }

    public int hashCode() {
        return NameUtil.nameHashCode(this.name);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("Attribute: ");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Name", this.getName());
        map.put("Value", this.getValue());
        this.extendToStringMap(map);
        bld.append(map);
        return bld.toString();
    }

    protected void extendToStringMap(Map<String, Object> map) {
    }

    public boolean equals(Object obj) {
        return this.attributeEquals(obj);
    }

    public final boolean attributeEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (!this.is(other.name)) {
            return false;
        }
        if (!CollectionUtil.equals(this.value, other.value)) {
            return false;
        }
        return this.attributeValueCompleteness == other.attributeValueCompleteness;
    }
}

