/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.internals.ReplicaKey;

public final class VoterSet {
    private final Map<Integer, VoterNode> voters;

    VoterSet(Map<Integer, VoterNode> voters) {
        if (voters.isEmpty()) {
            throw new IllegalArgumentException("Voters cannot be empty");
        }
        this.voters = voters;
    }

    public Set<Node> voterNodes(Stream<Integer> voterIds, ListenerName listenerName) {
        return voterIds.map(voterId -> this.voterNode((int)voterId, listenerName).orElseThrow(() -> new IllegalArgumentException(String.format("Unable to find endpoint for voter %d and listener %s in %s", voterId, listenerName, this.voters)))).collect(Collectors.toSet());
    }

    public Optional<Node> voterNode(int voterId, ListenerName listenerName) {
        return Optional.ofNullable(this.voters.get(voterId)).flatMap(voterNode -> voterNode.address(listenerName)).map(address -> new Node(voterId, address.getHostString(), address.getPort()));
    }

    public boolean isVoter(ReplicaKey nodeKey) {
        VoterNode node = this.voters.get(nodeKey.id());
        if (node != null) {
            if (node.voterKey().directoryId().isPresent()) {
                return node.voterKey().directoryId().equals(nodeKey.directoryId());
            }
            return true;
        }
        return false;
    }

    public boolean isOnlyVoter(ReplicaKey nodeKey) {
        return this.voters.size() == 1 && this.isVoter(nodeKey);
    }

    public Set<Integer> voterIds() {
        return this.voters.keySet();
    }

    public Optional<VoterSet> addVoter(VoterNode voter) {
        if (this.voters.containsKey(voter.voterKey().id())) {
            return Optional.empty();
        }
        HashMap<Integer, VoterNode> newVoters = new HashMap<Integer, VoterNode>(this.voters);
        newVoters.put(voter.voterKey().id(), voter);
        return Optional.of(new VoterSet(newVoters));
    }

    public Optional<VoterSet> removeVoter(ReplicaKey voterKey) {
        VoterNode oldVoter = this.voters.get(voterKey.id());
        if (oldVoter != null && Objects.equals(oldVoter.voterKey(), voterKey)) {
            HashMap<Integer, VoterNode> newVoters = new HashMap<Integer, VoterNode>(this.voters);
            newVoters.remove(voterKey.id());
            return Optional.of(new VoterSet(newVoters));
        }
        return Optional.empty();
    }

    public VotersRecord toVotersRecord(short version) {
        Function<VoterNode, VotersRecord.Voter> voterConvertor = voter -> {
            Iterator endpoints = voter.listeners().entrySet().stream().map(entry -> new VotersRecord.Endpoint().setName(((ListenerName)entry.getKey()).value()).setHost(((InetSocketAddress)entry.getValue()).getHostString()).setPort(((InetSocketAddress)entry.getValue()).getPort())).iterator();
            VotersRecord.KRaftVersionFeature kraftVersionFeature = new VotersRecord.KRaftVersionFeature().setMinSupportedVersion(voter.supportedKRaftVersion().min()).setMaxSupportedVersion(voter.supportedKRaftVersion().max());
            return new VotersRecord.Voter().setVoterId(voter.voterKey().id()).setVoterDirectoryId(voter.voterKey().directoryId().orElse(Uuid.ZERO_UUID)).setEndpoints(new VotersRecord.EndpointCollection(endpoints)).setKRaftVersionFeature(kraftVersionFeature);
        };
        List voterRecordVoters = this.voters.values().stream().map(voterConvertor).collect(Collectors.toList());
        return new VotersRecord().setVersion(version).setVoters(voterRecordVoters);
    }

    public boolean hasOverlappingMajority(VoterSet that) {
        Set thatReplicaKeys;
        Set thisReplicaKeys = this.voters.values().stream().map(VoterNode::voterKey).collect(Collectors.toSet());
        if (Utils.diff(HashSet::new, thisReplicaKeys, thatReplicaKeys = that.voters.values().stream().map(VoterNode::voterKey).collect(Collectors.toSet())).size() > 1) {
            return false;
        }
        return Utils.diff(HashSet::new, thatReplicaKeys, thisReplicaKeys).size() <= 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoterSet that = (VoterSet)o;
        return this.voters.equals(that.voters);
    }

    public int hashCode() {
        return Objects.hashCode(this.voters);
    }

    public String toString() {
        return String.format("VoterSet(voters=%s)", this.voters);
    }

    public static VoterSet fromVotersRecord(VotersRecord voters) {
        HashMap<Integer, VoterNode> voterNodes = new HashMap<Integer, VoterNode>(voters.voters().size());
        for (VotersRecord.Voter voter : voters.voters()) {
            Optional<Object> directoryId = !voter.voterDirectoryId().equals((Object)Uuid.ZERO_UUID) ? Optional.of(voter.voterDirectoryId()) : Optional.empty();
            HashMap<ListenerName, InetSocketAddress> listeners = new HashMap<ListenerName, InetSocketAddress>(voter.endpoints().size());
            for (VotersRecord.Endpoint endpoint : voter.endpoints()) {
                listeners.put(ListenerName.normalised((String)endpoint.name()), InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
            }
            voterNodes.put(voter.voterId(), new VoterNode(ReplicaKey.of(voter.voterId(), directoryId), listeners, new SupportedVersionRange(voter.kRaftVersionFeature().minSupportedVersion(), voter.kRaftVersionFeature().maxSupportedVersion())));
        }
        return new VoterSet(voterNodes);
    }

    public static VoterSet fromInetSocketAddresses(ListenerName listener, Map<Integer, InetSocketAddress> voters) {
        Map<Integer, VoterNode> voterNodes = voters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new VoterNode(ReplicaKey.of((Integer)entry.getKey(), Optional.empty()), Collections.singletonMap(listener, entry.getValue()), new SupportedVersionRange(0, 0))));
        return new VoterSet(voterNodes);
    }

    public static final class VoterNode {
        private final ReplicaKey voterKey;
        private final Map<ListenerName, InetSocketAddress> listeners;
        private final SupportedVersionRange supportedKRaftVersion;

        VoterNode(ReplicaKey voterKey, Map<ListenerName, InetSocketAddress> listeners, SupportedVersionRange supportedKRaftVersion) {
            this.voterKey = voterKey;
            this.listeners = listeners;
            this.supportedKRaftVersion = supportedKRaftVersion;
        }

        public ReplicaKey voterKey() {
            return this.voterKey;
        }

        Map<ListenerName, InetSocketAddress> listeners() {
            return this.listeners;
        }

        SupportedVersionRange supportedKRaftVersion() {
            return this.supportedKRaftVersion;
        }

        Optional<InetSocketAddress> address(ListenerName listener) {
            return Optional.ofNullable(this.listeners.get(listener));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VoterNode that = (VoterNode)o;
            if (!Objects.equals(this.voterKey, that.voterKey)) {
                return false;
            }
            if (!Objects.equals(this.supportedKRaftVersion, that.supportedKRaftVersion)) {
                return false;
            }
            return Objects.equals(this.listeners, that.listeners);
        }

        public int hashCode() {
            return Objects.hash(this.voterKey, this.listeners, this.supportedKRaftVersion);
        }

        public String toString() {
            return String.format("VoterNode(voterKey=%s, listeners=%s, supportedKRaftVersion=%s)", this.voterKey, this.listeners, this.supportedKRaftVersion);
        }
    }
}

