/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Predef$;

public final class Server$ {
    public static final Server$ MODULE$ = new Server$();
    private static final String MetricsPrefix = "kafka.server";
    private static final String ClusterIdLabel = "kafka.cluster.id";
    private static final String BrokerIdLabel = "kafka.broker.id";
    private static final String NodeIdLabel = "kafka.node.id";

    public String MetricsPrefix() {
        return MetricsPrefix;
    }

    public String ClusterIdLabel() {
        return ClusterIdLabel;
    }

    public String BrokerIdLabel() {
        return BrokerIdLabel;
    }

    public String NodeIdLabel() {
        return NodeIdLabel;
    }

    public Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(config, clusterId);
        return this.buildMetrics(config, time, metricsContext);
    }

    private Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        MetricConfig metricConfig = this.buildMetricsConfig(config);
        return new Metrics(metricConfig, new ArrayList(), time, true, (MetricsContext)metricsContext);
    }

    public MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.ClusterIdLabel(), clusterId);
        if (config.usesSelfManagedQuorum()) {
            contextLabels.put(this.NodeIdLabel(), Integer.toString(config.nodeId()));
        } else {
            contextLabels.put(this.BrokerIdLabel(), Integer.toString(config.brokerId()));
        }
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        return new KafkaMetricsContext(this.MetricsPrefix(), contextLabels);
    }

    private Server$() {
    }
}

