/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.mongodb.client.MongoClient;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.mongo.SAML2MongoMetadataGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoOperations;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml-mongodb", enabledByDefault=false)
@Configuration(value="DelegatedAuthenticationSaml2MongoDbConfiguration", proxyBeanMethods=false)
@ConditionalOnClass(value={CasMongoOperations.class})
class DelegatedAuthenticationSaml2MongoDbConfiguration {
    DelegatedAuthenticationSaml2MongoDbConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"delegatedSaml2ClientMongoDbMetadataCustomizer"})
    public DelegatedClientFactoryCustomizer delegatedSaml2ClientMongoDbMetadataCustomizer(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        return client -> {
            if (client instanceof SAML2Client) {
                SAML2Client saml2Client = (SAML2Client)client;
                SAML2Configuration configuration = saml2Client.getConfiguration();
                casProperties.getAuthn().getPac4j().getSaml().stream().map(saml -> saml.getMetadata().getServiceProvider().getMongo()).filter(saml -> StringUtils.isNotBlank((CharSequence)saml.getCollection())).forEach(mongo -> {
                    MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
                    MongoClient mongoClient = factory.buildMongoDbClient((BaseMongoDbProperties)mongo);
                    CasMongoOperations mongoTemplate = factory.buildMongoTemplate(mongoClient, (BaseMongoDbProperties)mongo);
                    MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
                    SAML2MongoMetadataGenerator metadataGenerator = new SAML2MongoMetadataGenerator(mongoClient, configuration.getServiceProviderEntityId());
                    metadataGenerator.setMetadataCollection(mongo.getCollection());
                    metadataGenerator.setMetadataDatabase(mongo.getDatabaseName());
                    configuration.setServiceProviderMetadataResource(ResourceUtils.NULL_RESOURCE);
                    configuration.setMetadataGenerator((SAML2MetadataGenerator)metadataGenerator);
                });
            }
        };
    }
}

