/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.widget.treeview;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.kendo.ui.KendoDataSource;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.widget.treeview.ITreeViewListener;

public abstract class AjaxTreeViewBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoTreeView";
    private final ITreeViewListener listener;
    private KendoDataSource.HierarchicalDataSource dataSource;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;
    private JQueryAjaxBehavior onExpandAjaxBehavior = null;
    private JQueryAjaxBehavior onDropAjaxBehavior = null;

    public AjaxTreeViewBehavior(String selector, ITreeViewListener listener) {
        this(selector, new Options(), listener);
    }

    public AjaxTreeViewBehavior(String selector, Options options, ITreeViewListener listener) {
        super(selector, METHOD, options);
        this.listener = (ITreeViewListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource.HierarchicalDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isChangeEventEnabled()) {
            this.onChangeAjaxBehavior = this.newOnChangeAjaxBehavior(this);
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
        if (this.listener.isExpandEventEnabled()) {
            this.onExpandAjaxBehavior = this.newOnExpandAjaxBehavior(this);
            component.add(new Behavior[]{this.onExpandAjaxBehavior});
        }
        if (this.listener.isDropEventEnabled()) {
            this.onDropAjaxBehavior = this.newOnDropAjaxBehavior(this);
            component.add(new Behavior[]{this.onDropAjaxBehavior});
        }
    }

    protected abstract CharSequence getDataSourceUrl();

    @Override
    public void onConfigure(Component component) {
        this.setOption("autoBind", true);
        this.setOption("loadOnDemand", true);
        if (this.onExpandAjaxBehavior != null) {
            this.setOption("expand", this.onExpandAjaxBehavior.getCallbackFunction());
        }
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
        if (this.onDropAjaxBehavior != null) {
            this.setOption("dragAndDrop", true);
            this.setOption("drop", this.onDropAjaxBehavior.getCallbackFunction());
        }
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.setTransportReadUrl(this.getDataSourceUrl());
        this.onConfigure(this.dataSource);
        super.onConfigure(component);
    }

    protected void onConfigure(KendoDataSource.HierarchicalDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        JQueryEvent payload;
        if (event instanceof ExpandEvent) {
            this.listener.onExpand(target, ((ExpandEvent)event).getNodeId());
        }
        if (event instanceof ChangeEvent) {
            payload = (ChangeEvent)event;
            this.listener.onChange(target, payload.getNodeId(), payload.getNodePath());
        }
        if (event instanceof DropEvent) {
            payload = (DropEvent)event;
            this.listener.onDrop(target, payload.getNodeId(), payload.getParentId(), payload.getPosition());
        }
    }

    protected JQueryAjaxBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source) {
        return new OnChangeAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnExpandAjaxBehavior(IJQueryAjaxAware source) {
        return new OnExpandAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnDropAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDropAjaxBehavior(source);
    }

    protected static class ExpandEvent
    extends JQueryEvent {
        private final int nodeId = RequestCycleUtils.getQueryParameterValue((String)"nodeId").toInt(0);

        public int getNodeId() {
            return this.nodeId;
        }
    }

    protected static class ChangeEvent
    extends JQueryEvent {
        private final int nodeId = RequestCycleUtils.getQueryParameterValue((String)"nodeId").toInt(0);
        private final String nodePath = RequestCycleUtils.getQueryParameterValue((String)"nodePath").toString();

        public int getNodeId() {
            return this.nodeId;
        }

        public String getNodePath() {
            return this.nodePath;
        }
    }

    protected static class DropEvent
    extends JQueryEvent {
        private final int nodeId = RequestCycleUtils.getQueryParameterValue((String)"nodeId").toInt(0);
        private final int parentId = RequestCycleUtils.getQueryParameterValue((String)"parentId").toInt(0);
        private final String position = RequestCycleUtils.getQueryParameterValue((String)"dropPosition").toString();

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }

        public String getPosition() {
            return this.position;
        }
    }

    protected static class OnChangeAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnChangeAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"nodeId", (String)String.format("this.dataItem(this.select()).%s", "nid")), CallbackParameter.resolved((String)"nodePath", (String)"path")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            StringBuilder builder = new StringBuilder();
            builder.append("var $treeview = this;");
            builder.append("var $node = this.select();");
            builder.append("var items = jQuery($node).add(jQuery($node).parentsUntil('.k-treeview', '.k-item'));");
            builder.append("var paths = jQuery.map(items, function(item) { ");
            builder.append("    var node = jQuery(item).find('> div span.k-in');");
            builder.append("    return $treeview.dataItem(node).").append("nid").append(";");
            builder.append("});");
            builder.append("var path = '[' + paths.join(',') + ']';");
            return builder.toString() + String.valueOf(super.getCallbackFunctionBody(parameters));
        }

        protected JQueryEvent newEvent() {
            return new ChangeEvent();
        }
    }

    protected static class OnExpandAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnExpandAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"nodeId", (String)String.format("this.dataItem(e.node).%s", "nid"))};
        }

        protected JQueryEvent newEvent() {
            return new ExpandEvent();
        }
    }

    protected static class OnDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDropAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"nodeId", (String)String.format("this.dataItem(e.sourceNode).%s", "nid")), CallbackParameter.resolved((String)"parentId", (String)String.format("this.dataItem(e.destinationNode).%s", "nid")), CallbackParameter.resolved((String)"dropPosition", (String)"e.dropPosition")};
        }

        protected JQueryEvent newEvent() {
            return new DropEvent();
        }
    }
}

