/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.datatable;

import com.github.openjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.StringValue;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.ListUtils;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.kendo.ui.KendoDataSource;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.datatable.DataSourceAjaxBehavior;
import org.wicketstuff.kendo.ui.datatable.DataSourceEvent;
import org.wicketstuff.kendo.ui.datatable.IDataTableListener;
import org.wicketstuff.kendo.ui.datatable.button.CommandAjaxBehavior;
import org.wicketstuff.kendo.ui.datatable.button.CommandButton;
import org.wicketstuff.kendo.ui.datatable.button.ToolbarAjaxBehavior;
import org.wicketstuff.kendo.ui.datatable.button.ToolbarButton;
import org.wicketstuff.kendo.ui.datatable.column.CheckboxColumn;
import org.wicketstuff.kendo.ui.datatable.column.CommandColumn;
import org.wicketstuff.kendo.ui.datatable.column.IColumn;
import org.wicketstuff.kendo.ui.datatable.column.IdPropertyColumn;
import org.wicketstuff.kendo.ui.repeater.ChangeEvent;

public abstract class DataTableBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoGrid";
    private final IDataTableListener listener;
    private final IModel<List<IColumn>> columns;
    private KendoDataSource dataSource;
    private JQueryAjaxBehavior onCancelAjaxBehavior;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;
    private JQueryAjaxBehavior onCheckedAjaxBehavior = null;
    private JQueryAjaxBehavior onColumnReorderAjaxBehavior = null;
    private DataSourceAjaxBehavior onCreateAjaxBehavior;
    private DataSourceAjaxBehavior onUpdateAjaxBehavior;
    private DataSourceAjaxBehavior onDeleteAjaxBehavior;

    public DataTableBehavior(String selector, IModel<List<IColumn>> columns, IDataTableListener listener) {
        this(selector, new Options(), columns, listener);
    }

    public DataTableBehavior(String selector, Options options, IModel<List<IColumn>> columns, IDataTableListener listener) {
        super(selector, METHOD, options);
        this.columns = columns;
        this.listener = (IDataTableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource(component);
        this.add(this.dataSource);
        this.onCancelAjaxBehavior = this.newOnCancelAjaxBehavior(this);
        component.add(new Behavior[]{this.onCancelAjaxBehavior});
        if (this.listener.isSelectable()) {
            this.onChangeAjaxBehavior = this.newOnChangeAjaxBehavior(this);
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
        if (this.hasCheckboxColumn()) {
            this.onCheckedAjaxBehavior = this.newOnCheckedAjaxBehavior(this);
            component.add(new Behavior[]{this.onCheckedAjaxBehavior});
        }
        if (this.isColumnReorderEnabled()) {
            this.onColumnReorderAjaxBehavior = this.newColumnReorderAjaxBehavior(this);
            component.add(new Behavior[]{this.onColumnReorderAjaxBehavior});
        }
        this.onCreateAjaxBehavior = this.newOnCreateAjaxBehavior(this);
        component.add(new Behavior[]{this.onCreateAjaxBehavior});
        this.onUpdateAjaxBehavior = this.newOnUpdateAjaxBehavior(this);
        component.add(new Behavior[]{this.onUpdateAjaxBehavior});
        this.onDeleteAjaxBehavior = this.newOnDeleteAjaxBehavior(this);
        component.add(new Behavior[]{this.onDeleteAjaxBehavior});
        for (ToolbarButton toolbarButton : this.getVisibleToolbarButtons()) {
            if (toolbarButton.isBuiltIn()) continue;
            component.add(new Behavior[]{this.newToolbarAjaxBehavior(this, toolbarButton)});
        }
        for (CommandButton commandButton : this.getVisibleCommandButtons()) {
            if (commandButton.isBuiltIn()) continue;
            component.add(new Behavior[]{this.newCommandAjaxBehavior(this, commandButton)});
        }
    }

    public boolean isColumnReorderEnabled() {
        Boolean value = (Boolean)this.options.get("reorderable");
        return value != null && value != false;
    }

    protected abstract long getRowCount();

    protected abstract CharSequence getProviderUrl();

    protected boolean useCache() {
        return false;
    }

    protected List<ToolbarButton> getToolbarButtons() {
        return Collections.emptyList();
    }

    protected List<ToolbarButton> getVisibleToolbarButtons() {
        ArrayList buttons = Generics.newArrayList();
        for (ToolbarButton button : this.getToolbarButtons()) {
            if (!button.isVisible()) continue;
            buttons.add(button);
        }
        return buttons;
    }

    protected boolean hasVisibleToolbarButtons() {
        return !this.getVisibleToolbarButtons().isEmpty();
    }

    protected boolean hasCheckboxColumn() {
        return ((List)this.columns.getObject()).stream().anyMatch(column -> column instanceof CheckboxColumn);
    }

    protected List<CommandButton> getCommandButtons() {
        ArrayList buttons = Generics.newArrayList();
        for (IColumn column : (List)this.columns.getObject()) {
            if (!(column instanceof CommandColumn)) continue;
            buttons.addAll(((CommandColumn)column).getButtons());
        }
        return buttons;
    }

    protected List<CommandButton> getVisibleCommandButtons() {
        ArrayList buttons = Generics.newArrayList();
        for (CommandButton button : this.getCommandButtons()) {
            if (!button.isVisible()) continue;
            buttons.add(button);
        }
        return buttons;
    }

    private static List<String> getCommandButtonsAsString(CommandColumn column, List<CommandAjaxBehavior> behaviors) {
        ArrayList list = Generics.newArrayList();
        for (CommandButton button : column.getButtons()) {
            if (!button.isVisible()) continue;
            JQueryAjaxBehavior behavior = DataTableBehavior.getCommandAjaxBehavior(button, behaviors);
            list.add(button.toString(behavior));
        }
        return list;
    }

    public static JQueryAjaxBehavior getCommandAjaxBehavior(CommandButton button, List<CommandAjaxBehavior> behaviors) {
        for (CommandAjaxBehavior behavior : behaviors) {
            if (!button.equals(behavior.getButton())) continue;
            return behavior;
        }
        return null;
    }

    private static String getColumnsAsString(List<IColumn> columns, List<CommandAjaxBehavior> behaviors) {
        StringBuilder builder = new StringBuilder("[ ");
        for (int i = 0; i < columns.size(); ++i) {
            IColumn column = columns.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("{ ");
            builder.append(column.toString());
            if (column instanceof CommandColumn) {
                builder.append(", ");
                builder.append("\"").append("command").append("\"").append(": ");
                builder.append(DataTableBehavior.getCommandButtonsAsString((CommandColumn)column, behaviors));
            }
            builder.append(" }");
        }
        return builder.append(" ]").toString();
    }

    private String getReadCallbackFunction() {
        return KendoDataSource.getReadCallbackFunction(this.getProviderUrl(), this.useCache());
    }

    @Override
    public void onConfigure(Component component) {
        List columns = (List)this.columns.getObject();
        this.setOption("cancel", this.onCancelAjaxBehavior.getCallbackFunction());
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
        if (this.onCheckedAjaxBehavior != null) {
            this.setOption("change", this.onCheckedAjaxBehavior.getCallbackFunction());
        }
        if (this.onColumnReorderAjaxBehavior != null) {
            this.setOption("columnReorder", this.onColumnReorderAjaxBehavior.getCallbackFunction());
        }
        if (this.hasVisibleToolbarButtons()) {
            this.setOption("toolbar", this.getVisibleToolbarButtons());
        }
        this.setOption("columns", DataTableBehavior.getColumnsAsString(columns, component.getBehaviors(CommandAjaxBehavior.class)));
        Options schema = new Options();
        schema.set("data", (Object)Options.asString((String)"results"));
        schema.set("total", (Object)Options.asString((String)"__count"));
        schema.set("model", (Object)this.newSchemaModelOptions(columns));
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.set("schema", schema);
        this.dataSource.set("pageSize", this.getRowCount());
        this.dataSource.set("serverPaging", true);
        this.dataSource.set("serverSorting", true);
        this.dataSource.set("serverFiltering", true);
        this.dataSource.setTransportRead(this.getReadCallbackFunction());
        this.dataSource.setTransportCreate(this.onCreateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportUpdate(this.onUpdateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportDelete(this.onDeleteAjaxBehavior.getCallbackFunction());
        this.onConfigure(this.dataSource);
        for (ToolbarAjaxBehavior behavior : component.getBehaviors(ToolbarAjaxBehavior.class)) {
            String selector = String.format("%s .k-grid-toolbar .k-grid-%s", this.getSelector(), behavior.getButtonName());
            this.off(selector, "click");
            this.on(selector, "click", behavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        JQueryEvent e;
        if (event instanceof ToolbarAjaxBehavior.ToolbarClickEvent) {
            e = (ToolbarAjaxBehavior.ToolbarClickEvent)event;
            e.getButton().onClick(target, e.getValues());
            this.listener.onClick(target, e.getButton(), e.getValues());
        }
        if (event instanceof CommandAjaxBehavior.CommandClickEvent) {
            e = (CommandAjaxBehavior.CommandClickEvent)event;
            e.getButton().onClick(target, e.getValue());
            this.listener.onClick(target, e.getButton(), e.getValue());
        }
        if (event instanceof CancelEvent) {
            this.listener.onCancel(target);
        }
        if (event instanceof ChangeEvent) {
            this.listener.onChange(target, ((ChangeEvent)event).getItems());
        }
        if (event instanceof CheckboxEvent) {
            this.listener.onChecked(target, ((CheckboxEvent)event).getSelectedKeys());
        }
        if (event instanceof ColumnReorderEvent) {
            e = (ColumnReorderEvent)event;
            this.listener.onColumnReorder(target, e.getOldIndex(), e.getNewIndex(), e.getObject());
        }
        if (event instanceof DataSourceEvent.CreateEvent) {
            this.listener.onCreate(target, ((DataSourceEvent)event).getObject());
        }
        if (event instanceof DataSourceEvent.UpdateEvent) {
            this.listener.onUpdate(target, ((DataSourceEvent)event).getObject());
        }
        if (event instanceof DataSourceEvent.DeleteEvent) {
            this.listener.onDelete(target, ((DataSourceEvent)event).getObject());
        }
    }

    protected Options newSchemaModelOptions(List<IColumn> columns) {
        Options model = new Options();
        Options fields = new Options();
        for (IColumn column : columns) {
            if (column.getField() == null) continue;
            if (column instanceof IdPropertyColumn) {
                model.set("id", (Object)Options.asString((String)column.getField()));
            }
            Options field = new Options();
            if (column.isEditable() != null) {
                field.set("editable", (Object)column.isEditable());
            }
            if (column.isNullable() != null) {
                field.set("nullable", (Object)column.isNullable());
            }
            if (column.getType() != null) {
                field.set("type", (Object)Options.asString((String)column.getType()));
            }
            fields.set(column.getField(), (Object)field);
        }
        model.set("fields", (Object)fields);
        return model;
    }

    protected JQueryAjaxBehavior newOnCancelAjaxBehavior(IJQueryAjaxAware source) {
        return new JQueryAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e")};
            }

            protected JQueryEvent newEvent() {
                return new CancelEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source) {
        return new OnChangeAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnCheckedAjaxBehavior(IJQueryAjaxAware source) {
        return new OnCheckedAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newColumnReorderAjaxBehavior(IJQueryAjaxAware source) {
        return new JQueryAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"oldIndex", (String)"e.oldIndex"), CallbackParameter.resolved((String)"newIndex", (String)"e.newIndex"), CallbackParameter.resolved((String)"data", (String)"kendo.stringify(e.column)")};
            }

            protected JQueryEvent newEvent() {
                return new ColumnReorderEvent();
            }
        };
    }

    protected DataSourceAjaxBehavior newOnCreateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.CreateEvent();
            }
        };
    }

    protected DataSourceAjaxBehavior newOnUpdateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.UpdateEvent();
            }
        };
    }

    protected DataSourceAjaxBehavior newOnDeleteAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.DeleteEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newToolbarAjaxBehavior(DataTableBehavior source, ToolbarButton button) {
        return new ToolbarAjaxBehavior(source, button);
    }

    protected abstract JQueryAjaxBehavior newCommandAjaxBehavior(IJQueryAjaxAware var1, CommandButton var2);

    protected static class CancelEvent
    extends JQueryEvent {
        protected CancelEvent() {
        }
    }

    protected static class CheckboxEvent
    extends JQueryEvent {
        private final List<String> selectedKeys = ListUtils.toStringList((StringValue)RequestCycleUtils.getQueryParameterValue((String)"values"));

        public List<String> getSelectedKeys() {
            return this.selectedKeys;
        }
    }

    protected static class ColumnReorderEvent
    extends JQueryEvent {
        private final int oldIndex = RequestCycleUtils.getQueryParameterValue((String)"oldIndex").toInt(0);
        private final int newIndex = RequestCycleUtils.getQueryParameterValue((String)"newIndex").toInt(0);
        private final JSONObject object;

        public ColumnReorderEvent() {
            String data = RequestCycleUtils.getQueryParameterValue((String)"data").toString();
            this.object = new JSONObject(data);
        }

        public int getOldIndex() {
            return this.oldIndex;
        }

        public int getNewIndex() {
            return this.newIndex;
        }

        public JSONObject getObject() {
            return this.object;
        }
    }

    protected static class OnChangeAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnChangeAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"items", (String)"items")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            Object statement = "";
            statement = (String)statement + "var $grid = e.sender;\n";
            statement = (String)statement + "var _rows = jQuery.map(this.select(), function(row) { return $grid.dataItem(row); });\n";
            statement = (String)statement + "var items = kendo.stringify(_rows);\n";
            return (String)statement + String.valueOf(super.getCallbackFunctionBody(parameters));
        }

        protected JQueryEvent newEvent() {
            return new ChangeEvent();
        }
    }

    protected static class OnCheckedAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnCheckedAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"values", (String)"this.selectedKeyNames()")};
        }

        protected JQueryEvent newEvent() {
            return new CheckboxEvent();
        }
    }
}

