/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.DefaultCasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.configuration.model.core.authentication.HttpClientTrustStoreProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.apereo.cas.util.http.SimpleHttpClientFactoryBean;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Order(value=-2147483648)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Core})
@Configuration(value="CasCoreHttpConfiguration", proxyBeanMethods=false)
class CasCoreHttpConfiguration {
    CasCoreHttpConfiguration() {
    }

    @Configuration(value="CasCoreHttpClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreHttpClientConfiguration {
        CasCoreHttpClientConfiguration() {
        }

        private static SimpleHttpClientFactoryBean buildHttpClientFactoryBean(CasSSLContext casSslContext, LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            SimpleHttpClientFactoryBean.DefaultHttpClient client = new SimpleHttpClientFactoryBean.DefaultHttpClient();
            HttpClientProperties httpClient = casProperties.getHttpClient();
            client.setConnectionTimeout(Beans.newDuration((String)httpClient.getConnectionTimeout()).toMillis());
            client.setSocketTimeout(Beans.newDuration((String)httpClient.getSocketTimeout()).toMillis());
            client.setResponseTimeout(Beans.newDuration((String)httpClient.getResponseTimeout()).toMillis());
            if (StringUtils.isNotBlank((CharSequence)httpClient.getProxyHost()) && httpClient.getProxyPort() > 0) {
                client.setProxy(new HttpHost(httpClient.getProxyHost(), httpClient.getProxyPort()));
            }
            client.setSslContext(casSslContext.getSslContext());
            client.setSslSocketFactory(trustStoreSslSocketFactory);
            client.setTrustManagers(casSslContext.getTrustManagers());
            ArrayList defaultHeaders = new ArrayList();
            httpClient.getDefaultHeaders().forEach((name, value) -> defaultHeaders.add(new BasicHeader(name, value)));
            client.setDefaultHeaders(defaultHeaders);
            return client;
        }

        private static SimpleHttpClient getHttpClient(boolean redirectEnabled, CasSSLContext casSslContext, LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            SimpleHttpClientFactoryBean factoryBean = CasCoreHttpClientConfiguration.buildHttpClientFactoryBean(casSslContext, trustStoreSslSocketFactory, casProperties);
            factoryBean.setRedirectsEnabled(redirectEnabled);
            factoryBean.setCircularRedirectsAllowed(redirectEnabled);
            return factoryBean.getObject();
        }

        @ConditionalOnMissingBean(name={"httpClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<SimpleHttpClient> httpClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="trustStoreSslSocketFactory") LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            return CasCoreHttpClientConfiguration.buildHttpClientFactoryBean(casSslContext, trustStoreSslSocketFactory, casProperties);
        }

        @ConditionalOnMissingBean(name={"noRedirectHttpClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HttpClient noRedirectHttpClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="trustStoreSslSocketFactory") LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            return CasCoreHttpClientConfiguration.getHttpClient(false, casSslContext, trustStoreSslSocketFactory, casProperties);
        }

        @ConditionalOnMissingBean(name={"supportsTrustStoreSslSocketFactoryHttpClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HttpClient supportsTrustStoreSslSocketFactoryHttpClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="trustStoreSslSocketFactory") LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            return CasCoreHttpClientConfiguration.getHttpClient(true, casSslContext, trustStoreSslSocketFactory, casProperties);
        }
    }

    @Configuration(value="CasCoreHttpTlsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreHttpTlsConfiguration {
        CasCoreHttpTlsConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casSslContext"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasSSLContext casSslContext(@Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier, CasConfigurationProperties casProperties) throws Exception {
            HttpClientTrustStoreProperties client = casProperties.getHttpClient().getTruststore();
            if (client.getFile() != null && client.getFile().exists() && StringUtils.isNotBlank((CharSequence)client.getPsw())) {
                return new DefaultCasSSLContext(client.getFile(), client.getPsw(), client.getType(), casProperties.getHttpClient(), hostnameVerifier);
            }
            if ("none".equalsIgnoreCase(casProperties.getHttpClient().getHostNameVerifier())) {
                return CasSSLContext.disabled();
            }
            return CasSSLContext.system();
        }
    }

    @Configuration(value="CasCoreHttpHostnameConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreHttpHostnameConfiguration {
        CasCoreHttpHostnameConfiguration() {
        }

        @ConditionalOnMissingBean(name={"hostnameVerifier"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HostnameVerifier hostnameVerifier(CasConfigurationProperties casProperties) {
            if ("none".equalsIgnoreCase(casProperties.getHttpClient().getHostNameVerifier())) {
                return NoopHostnameVerifier.INSTANCE;
            }
            return new DefaultHostnameVerifier();
        }
    }

    @Configuration(value="CasCoreHttpSslFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreHttpSslFactoryConfiguration {
        CasCoreHttpSslFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"trustStoreSslSocketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LayeredConnectionSocketFactory trustStoreSslSocketFactory(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier) {
            return new SSLConnectionSocketFactory(casSslContext.getSslContext(), hostnameVerifier);
        }
    }
}

