/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token.ciba;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.oidc.OidcCibaVerificationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.token.ciba.CibaTokenDeliveryHandler;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;

public class CibaPushTokenDeliveryHandler
implements CibaTokenDeliveryHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CibaPushTokenDeliveryHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).defaultTypingEnabled(false).build().toObjectMapper();
    private final OidcBackchannelTokenDeliveryModes deliveryMode = OidcBackchannelTokenDeliveryModes.PUSH;
    private final OidcConfigurationContext configurationContext;

    @Override
    public Map<String, ?> deliver(OidcRegisteredService registeredService, OidcCibaRequest cibaRequest) throws Throwable {
        WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceServiceFactory().createService(cibaRequest.getClientId());
        OAuth20TokenGeneratedResult generatedTokenResult = this.generateAccessToken(registeredService, cibaRequest, service);
        ModelAndView payload = this.generateResponsePayload(registeredService, cibaRequest, generatedTokenResult, service);
        this.sendPushNotification(registeredService, cibaRequest, payload.getModel());
        return payload.getModel();
    }

    protected void sendPushNotification(OidcRegisteredService registeredService, OidcCibaRequest cibaRequest, Map payload) {
        OidcCibaVerificationProperties verification = this.configurationContext.getCasProperties().getAuthn().getOidc().getCiba().getVerification();
        long delayInSeconds = Beans.newDuration((String)verification.getDelay()).toSeconds();
        this.configurationContext.getTaskScheduler().schedule(() -> {
            HttpResponse response = null;
            try {
                String clientNotificationValue = (String)cibaRequest.getAuthentication().getSingleValuedAttribute("client_notification_token", String.class);
                HttpExecutionRequest exec = HttpExecutionRequest.builder().bearerToken(clientNotificationValue).method(HttpMethod.POST).url(registeredService.getBackchannelClientNotificationEndpoint()).entity(MAPPER.writeValueAsString((Object)payload)).httpClient(this.configurationContext.getHttpClient()).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).build();
                LOGGER.debug("Sending a POST request to [{}] with payload [{}]", (Object)exec.getUrl(), (Object)exec.getEntity());
                response = HttpUtils.execute((HttpExecutionRequest)exec);
                if (!HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful()) {
                    LOGGER.error("Unable to deliver tokens to client application [{}]", (Object)registeredService.getName());
                    this.configurationContext.getTicketRegistry().deleteTicket((Ticket)cibaRequest);
                }
                HttpUtils.close((HttpResponse)response);
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
            finally {
                HttpUtils.close(response);
            }
        }, LocalDateTime.now(Clock.systemUTC()).plusSeconds(delayInSeconds).toInstant(ZoneOffset.UTC));
    }

    protected ModelAndView generateResponsePayload(OidcRegisteredService registeredService, OidcCibaRequest cibaRequest, OAuth20TokenGeneratedResult generatedTokenResult, WebApplicationService service) {
        OAuth20AccessTokenResponseResult tokenResult = OAuth20AccessTokenResponseResult.builder().registeredService((RegisteredService)registeredService).accessTokenTimeout(((Ticket)generatedTokenResult.getAccessToken().orElseThrow()).getExpirationPolicy().getTimeToLive().longValue()).responseType(OAuth20ResponseTypes.NONE).casProperties(this.configurationContext.getCasProperties()).generatedToken(generatedTokenResult).grantType(OAuth20GrantTypes.CIBA).cibaRequestId(cibaRequest.getEncodedId()).service((Service)service).build();
        ModelAndView payload = this.configurationContext.getAccessTokenResponseGenerator().generate(tokenResult);
        payload.addObject("auth_req_id", (Object)cibaRequest.getEncodedId());
        LOGGER.debug("Generated access token response payload [{}]", (Object)payload.getModel());
        return payload;
    }

    protected OAuth20TokenGeneratedResult generateAccessToken(OidcRegisteredService registeredService, OidcCibaRequest cibaRequest, WebApplicationService service) throws Throwable {
        AccessTokenRequestContext tokenRequestContext = AccessTokenRequestContext.builder().scopes(cibaRequest.getScopes()).grantType(OAuth20GrantTypes.CIBA).registeredService((OAuthRegisteredService)registeredService).authentication(cibaRequest.getAuthentication()).service((Service)service).cibaRequestId(cibaRequest.getEncodedId()).generateRefreshToken(registeredService.isGenerateRefreshToken()).build();
        return this.configurationContext.getAccessTokenGenerator().generate(tokenRequestContext);
    }

    @Generated
    public CibaPushTokenDeliveryHandler(OidcConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Override
    @Generated
    public OidcBackchannelTokenDeliveryModes getDeliveryMode() {
        return this.deliveryMode;
    }

    @Generated
    public OidcConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

