/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;

public final class ETrapException
extends ArithmeticException {
    private static final long serialVersionUID = 1L;
    private final Object result;
    private final EContext ctx;
    private final int error;
    private final int errors;

    public final EContext getContext() {
        return this.ctx;
    }

    public ETrapException() {
        this(ETrapException.FlagToMessage(64));
    }

    public ETrapException(String message) {
        super(message);
        this.error = 64;
        this.errors = 64;
        this.ctx = null;
        this.result = null;
    }

    public ETrapException(String message, Throwable innerException) {
        super(message);
        this.initCause(innerException);
        this.error = 64;
        this.errors = 64;
        this.ctx = this.ctx == null ? null : this.ctx.Copy();
        this.result = null;
    }

    public final Object getResult() {
        return this.result;
    }

    public final int getError() {
        return this.error;
    }

    public final int getErrors() {
        return this.errors;
    }

    public boolean HasError(int flag) {
        return (this.getError() & flag) == flag;
    }

    private static String FlagToMessage(int flags) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < 32; ++i) {
            int flag = 1 << i;
            if ((flags & flag) == 0) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            String str = flag == 32 ? "Clamped" : (flag == 128 ? "DivideByZero" : (flag == 1 ? "Inexact" : (flag == 64 ? "Invalid" : (flag == 16 ? "Overflow" : (flag == 2 ? "Rounded" : (flag == 4 ? "Subnormal" : (flag == 8 ? "Underflow" : "Trap")))))));
            sb.append(str);
        }
        return sb.toString();
    }

    public ETrapException(int flag, EContext ctx, Object result) {
        this(flag, flag, ctx, result);
    }

    public ETrapException(int flags, int flag, EContext ctx, Object result) {
        super(ETrapException.FlagToMessage(flags));
        if ((flags & flag) != flag) {
            throw new IllegalArgumentException("flags doesn't include flag");
        }
        this.error = flag;
        this.errors = flags;
        this.ctx = ctx == null ? null : ctx.Copy();
        this.result = result;
    }
}

