/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class LDAPSDKException
extends Exception {
    private static final long serialVersionUID = 8080186918165352228L;

    protected LDAPSDKException(@NotNull String message) {
        super(message);
    }

    protected LDAPSDKException(@NotNull String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    @Override
    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append(super.toString());
    }

    @NotNull
    public String getExceptionMessage() {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        return this.getExceptionMessage(includeCause, includeStackTrace);
    }

    @NotNull
    public String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        StringBuilder buffer = new StringBuilder();
        String message = this.getMessage();
        if (message == null || message.isEmpty()) {
            this.toString(buffer);
        } else {
            buffer.append(message);
        }
        if (includeStackTrace) {
            buffer.append(", trace=");
            StaticUtils.getStackTrace(this, buffer);
        } else if (includeCause && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=6.0.11, revision=8b21d0a4c6eb8b5c3e60a96fc3e9e13b9c2f650f";
        if (buffer.indexOf(", ldapSDKVersion=6.0.11, revision=8b21d0a4c6eb8b5c3e60a96fc3e9e13b9c2f650f") < 0) {
            buffer.append(", ldapSDKVersion=6.0.11, revision=8b21d0a4c6eb8b5c3e60a96fc3e9e13b9c2f650f");
        }
        return buffer.toString();
    }
}

